

<?php $__env->startSection('title'); ?> Bill Payments <?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    .br_ui {
        border: 4px solid gray;
        border-radius: 30px;
    }

    .pointer {
        cursor: pointer;
    }
    .receipt {

--vz-modal-width: 900px;

}
</style>

<link href="<?php echo e(URL::asset('/assets/libs/choices.js/choices.js.min.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php $__env->startComponent('components.breadcrumb'); ?>

<?php $__env->slot('li_1'); ?> Services <?php $__env->endSlot(); ?>

<?php $__env->slot('title'); ?> Bill Payments <?php $__env->endSlot(); ?>

<?php echo $__env->renderComponent(); ?>
<div class="row">

    <div class="col-lg-8">

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Bill Payments</h4>

            </div>

            <div class="card-body">
                <div class="row mb-2">
                    <div class="col-lg-3 pointer" onclick="selectService(3,'Electricity')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/10.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Electricity</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(5,'Water')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/9.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Water</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(6,'FasTag')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/5.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">FasTag</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(7,'Cable Tv')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/6.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Cable Tv</h5>
                        </div>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-lg-3 pointer" onclick="selectService(9,'Book Cylinder')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/7.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Book Cylinder</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(10,'Piped Gas')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/8.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Piped Gas</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(15,'Postpaid')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/3.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Postpaid</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(16,'Wifi/Landline')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/11.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Wifi/Landline</h5>
                        </div>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-lg-3 pointer" onclick="selectService(14,'Broadband')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/23.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Broadband</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(17,'Housing Society')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/24.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Housing Society</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(12,'Credit Card')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/15.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Credit Card</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(8,'Insurance Pay')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/16.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Insurance</h5>
                        </div>
                    </div>
                </div>
                <div class="row mb-2">
                    <div class="col-lg-3 pointer" onclick="selectService(4,'Loan Repayment')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/19.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Loan Repayment</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(11,'Subscription Fees')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/20.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Subscription Fees</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(18,'Google Play')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/21.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Google Play</h5>
                        </div>
                    </div>
                    <div class="col-lg-3 pointer" onclick="selectService(13,'Municipal Taxes')">
                        <div class="card-body text-center br_ui">
                            <div class="avatar-md mb-2 mx-auto">
                                <img src="<?php echo e(URL::asset('service_logo/22.png')); ?>" alt="" style="height:70px">
                            </div>
                            <h5 id="candidate-name" class="mb-0">Municipal Taxes</h5>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

    <div class="col-lg-4">

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1" id="service_name"><?php echo e($service ? $service : "Select Service"); ?>

                </h4>

            </div>

            <div class="card-body">
                <div class="col-lg-12 col-md-12">
                    <div class="mb-3">
                        <input type="hidden" name="service_id" id="service_id"
                            value="<?php echo e($service_id ? $service_id : 0); ?>">
                        <label for="provider_id" class="form-label text-muted">Provider : </label>
                        <select class="form-control" data-choices name="provider_id" id="provider_id">
                            <option value="">Select Provider</option>
                            <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($list->id); ?>"><?php echo e($list->provider_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>
                </div>
                <form id="params_div"></form>
                <div id="bill_details_div" style="display:none">
                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="userName" class="form-label text-muted">Name : </label>
                                <input type="text" class="form-control" name="userName" id="userName" value="" readonly>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="billAmount" class="form-label text-muted">Bill Amount : </label>
                                <input type="text" class="form-control" name="billAmount" id="billAmount" value=""
                                    readonly>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="billnetamount" class="form-label text-muted">Bill Net Amount : </label>
                                <input type="text" class="form-control" name="billnetamount" id="billnetamount" value=""
                                    readonly>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="minBillAmount" class="form-label text-muted">Min Bill Amount : </label>
                                <input type="text" class="form-control" name="minBillAmount" id="minBillAmount" value=""
                                    readonly>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="billdate" class="form-label text-muted">Bill Date : </label>
                                <input type="text" class="form-control" name="billdate" id="billdate" value="" readonly>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="mb-3">
                                <label for="dueDate" class="form-label text-muted">Due Date : </label>
                                <input type="text" class="form-control" name="dueDate" id="dueDate" value="" readonly>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-12 col-md-12">
                    <div class="mb-3" id="bill_amount" style="display:none">
                        <label for="pay_amount" class="form-label text-muted">Enter Amount: </label>
                        <input type="number" class="form-control" name="pay_amount" id="pay_amount" value="" required
                            placeholder="Enter Amount">
                    </div>
                    <div class="mb-3">
                        <button type="button" id="bill_pay" onclick="billPaymentNow()"
                            class="form-control btn btn-primary bg-gradient waves-effect waves-light"
                            style="display:none">Pay
                            Now</button>
                        <div class="mb-3">
                            <button type="button" id="bill_fatch" onclick="billFatch()"
                                class="form-control btn btn-warning bg-gradient waves-effect waves-light"
                                style="display:none">Bill
                                Fetch Now</button>
                        </div>
                    </div>
                </div>



            </div>

        </div>

    </div>
</div>



<!-- Details Modals -->

<div id="detailsModal" class="modal" tabindex="-1" aria-labelledby="detailsModalLabel" data-bs-backdrop="static"
    data-bs-keyboard="false" aria-hidden="true" style="display: none;">

    <div class="modal-dialog">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title" id="detailsModalLabel">Confirm Details</h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>

            </div>

            <div class="modal-body">

                <form>

                    <?php echo csrf_field(); ?>

                    <table class="table table-success table-striped align-middle table-nowrap mb-0">

                        <thead>

                            <tr>

                                <th>Biller Number : </th>

                                <th id="cd_number"></th>

                            </tr>

                        </thead>

                        <thead>

                            <tr>

                                <th>Provider Name : </th>

                                <th id="cd_provider"></th>



                            </tr>

                        </thead>

                        <thead>

                            <tr>

                                <th>Amount : </th>

                                <th id="cd_amount"></th>

                            </tr>

                        </thead>



                    </table>

                    <div class="mb-3">

                        <label>Enter PIN <span class="text-danger">*</span></label>

                        <input type="number" name="t_pin" id="t_pin" class="form-control" required="">

                    </div>

                </form>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>

                <button type="submit" class="btn btn-primary" id="bill_pay_now_btn"
                    onclick="billPaymentConfirm()">Confirm Now</button>

            </div>

        </div><!-- /.modal-content -->

    </div><!-- /.modal-dialog -->

</div><!-- /.modal -->


<div id="receiptModal" class="modal flip receipt" tabindex="-1" aria-labelledby="receiptModalLabel"
    data-bs-backdrop="static" data-bs-keyboard="false" aria-hidden="true" style="display: none;">

    <div class="modal-dialog modal-dialog-centered">

        <div class="modal-content">

            <div class="modal-header">

                <h5 class="modal-title" id="receiptModalLabel">Bill Payments Receipt</h5>

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>

            </div>

            <div class="modal-body receipt_modal_body">

                <table width="100%">

                    <tbody>

                        <tr>

                            <td>

                                <table width="100%" style="border: 1px solid black">

                                    <tbody>

                                        <?php

                                            $company = DB::table('companies')->where('status', "1")->where('domain', $_SERVER['HTTP_HOST'])->first();

                                        ?>

                                        <tr>

                                            <td style="width:50%"><img
                                                    src="<?php echo e(env('ADMIN_HOST')); ?>/company_logo/<?php echo e($company->company_logo); ?>"
                                                    style="height: 60px;"></td>

                                            <td style="width:50%;"> <strong
                                                    style="display: inline-block;overflow: hidden;white-space: nowrap;float: right;padding-right: 10px;"><?php echo e($company->company_name); ?></strong><br>
                                                <strong style="float: right;padding-right: 10px;">Email:
                                                    <?php echo e($company->support_email); ?></strong>

                                            </td>

                                        </tr>

                                    </tbody>

                                </table>

                            </td>

                        </tr>

                        <tr>

                            <td>

                                <table width="100%" style="border: 1px solid black">

                                    <tbody>

                                        <tr>

                                            <td
                                                style="width:33.33% ; border: 1px solid black;text-align: left;padding-left: 10px;">

                                                <strong>Agent Name :

                                                    <?php echo e(DB::table('users')->where('id', Session::get('user_id'))->first()->first_name); ?>




                                                    <?php echo e(DB::table('users')->where('id', Session::get('user_id'))->first()->last_name); ?>


                                                </strong><br>

                                                <strong>Agent Id :
                                                    <?php echo e(DB::table('users')->where('id', Session::get('user_id'))->first()->mobile_number); ?></strong><br>

                                                <strong>Order Id : <strong id="rc_order_id"></strong></strong><br>

                                            </td>

                                            <td style="width:33.33% ; border: 1px solid black">

                                                <h3 class=""
                                                    style="margin-top: 15px;text-align: center;text-transform: uppercase;"
                                                    id="rc_transaction_type"></h3>

                                            </td>

                                            <td
                                                style="width:33.33% ; border: 1px solid black;text-align: right;padding-right: 10px;">

                                                <div> <span>Date &amp; Time</span><br>

                                                    <strong id="rc_date_time"></strong>

                                                </div>

                                            </td>

                                        </tr>

                                    </tbody>

                                </table>

                            </td>

                        </tr>

                        <tr>

                            <td>

                                <table width="100%" style="text-align: center;border: 1px solid black">

                                    <tbody>

                                        <tr>

                                            <td style="width:100%; border: 1px solid black; margin:5px">

                                                <strong id="rc_remark"></strong>

                                            </td>

                                        </tr>

                                    </tbody>

                                </table>

                            </td>

                        </tr>

                        <tr>

                            <td>

                                <table width="100%" style="border: 1px solid black">

                                    <tbody>

                                        <tr class="">

                                            <th style="text-align: center;border: 1px solid black">Provider</th>

                                            <th style="text-align: center;border: 1px solid black" class="text-center">
                                                Status</th>

                                            <th style="text-align: center;border: 1px solid black" class="text-center">
                                                Operator Id </th>

                                            <th style="text-align: center;border: 1px solid black" class="text-center">
                                                Amount</th>

                                        </tr>

                                        <tr>

                                            <td width="40%" style="text-align: center;border: 1px solid black">

                                                <p class="font-weight-semibold mb-1" style="text-transform: uppercase;"
                                                    id="rc_provider"></p>

                                            </td>

                                            <td width="10%" style="text-align: center;border: 1px solid black">

                                                <p class="font-weight-semibold mb-1" style="text-transform: uppercase;"
                                                    id="rc_status"></p>

                                            </td>

                                            <td width="15%" style="text-align: center;border: 1px solid black">

                                                <p class="font-weight-semibold mb-1" id="rc_operator_id"></p>

                                            </td>

                                            <td width="15%" style="text-align: center;border: 1px solid black">

                                                <p class="font-weight-semibold mb-1" id="rc_amount"></p>

                                            </td>

                                        </tr>



                                    </tbody>

                                </table>

                            </td>

                        </tr>

                        <tr>

                            <td>

                                <table width="100%" style="border: 1px solid black">

                                    <tbody>

                                        <tr>

                                            <td><span style="color: red;">Receipt was created on a computer and is

                                                    valid without the signature and seal.</span> </td>

                                        </tr>

                                    </tbody>

                                </table>

                            </td>

                        </tr>

                    </tbody>

                </table>

            </div>

            <div class="modal-footer">

                <button type="button" class="btn btn-warning" data-bs-dismiss="modal">Close</button>

                <button type="submit" class="btn btn-secondary" id="receipt_print_btn" onclick="receiptPrint()"><i
                        class="ri-printer-line align-bottom me-1"></i> Print Receipt</button>

            </div>

        </div><!-- /.modal-content -->

    </div><!-- /.modal-dialog -->

</div><!-- /.modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"
    integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script>
    function selectService(id, name) {
        window.location = 'bill-payments?id=' + id + '&name=' + name;

    }

    ///readonly disabled
    $("#provider_id").on("change", function (e) {
        $("#params_div").empty();
        $('#bill_fatch').hide();
        $.ajax({

            url: '<?php echo e(route('fetchProviderParams')); ?>',

            method: 'post',

            data: {

                id: e.target.value,

                _token: '<?php echo e(csrf_token()); ?>'

            },

            success: function (data) {
                if (data.type == "success") {
                    params = JSON.parse(data.biller.biller_data);
                    console.log(params);
                    var param = {}; // my object
                    var params_data = []; // my array
                    param = { param: params.data.label_1, regex: params.data.regex_1, option: params.data.regex_1_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_2, regex: params.data.regex_2, option: params.data.regex_2_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_3, regex: params.data.regex_3, option: params.data.regex_3_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_4, regex: params.data.regex_4, option: params.data.regex_4_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_5, regex: params.data.regex_5, option: params.data.regex_5_autocomplete_values }
                    params_data.push(param);
                    console.log(params_data);
                    /////

                    html = '';
                    count = parseInt(params.input_count);
                    for (i = 0; i < parseInt(count); ++i) {
                        if (params_data[i].regex) {
                            regex = '<input type="text" class="form-control" name="' + "filed_" + i + '" value="" id="' + "filed_" + i + '"  pattern="' + params_data[i].regex + '" required placeholder="' + params_data[i].param + '">';
                        } else {
                            options = '';
                            for (i2 = 0; i2 < params_data[i].option.length; ++i2) {
                                options += '<option value="' + params_data[i].option[i2].value + '">' + params_data[i].option[i2].display_name + '</option>';
                            }
                            regex = '<select class="form-control" data-choices name="' + "filed_" + i + '" id="' + "filed_" + i + '">' +
                                '<option value="">Select ' + params_data[i].param + '</option>' +
                                options +
                                '</select>';
                        }
                        html += '<div class="col-lg-12 col-md-12">' +
                            '<div class="mb-3">' +
                            '<label for="' + "filed_" + i + '" class="form-label text-muted">' + params_data[i].param + '</label>' +
                            regex +
                            '</div>' +
                            '</div>';
                        //    $("#params_div").append(html); 
                    }
                    ///
                    if(data.provider.bill_fetch == "1"){
						$('#bill_amount').hide();
						$('#bill_pay').hide();
						$('#bill_fatch').show();
					}else{
						$('#bill_amount').show();
						$('#bill_pay').show();
						$('#bill_fatch').hide();
					}
                    ///
                    $("#params_div").append(html);
                   // $('#bill_fatch').show();
                } else {
                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);
                }
            },
            error: function (err) {
                Error_Msg("Oops...", "Something went wrong!", "error");
            }

        });

    });


    function billFatch() {
        var provider_id = $("#provider_id").val();
        var param_data = $('#params_div').serialize() + '&provider_id=' + provider_id + '&_token=<?php echo e(csrf_token()); ?>';
        $("#bill_fatch").text('Please wait...');
        $('#bill_fatch').prop('disabled', true);
        $.ajax({
            url: '<?php echo e(route('fetchBillDetails')); ?>',
            method: 'post',
            data: param_data,
            success: function (data) {
                $("#bill_fatch").text('Bill Fetch Now');
                $('#bill_fatch').prop('disabled', false);
                if (data.type == "success") {
                    $("#pay_amount").val(data.data.minBillAmount);
                    $("#billAmount").val(data.data.billAmount);
                    $("#billnetamount").val(data.data.billnetamount);
                    $("#billdate").val(data.data.billdate);
                    $("#dueDate").val(data.data.dueDate);
                    $("#minBillAmount").val(data.data.minBillAmount);
                    $("#acceptPayment").val(data.data.acceptPayment);
                    $("#acceptPartPay").val(data.data.acceptPartPay);
                    $("#userName").val(data.data.userName);
                    $('#bill_fatch').hide();
                    $('#bill_details_div').show();
                    $('#bill_amount').show();
                    $('#bill_pay').show();
                    $('#filed_0').attr('readonly', true);
                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);
                } else {
                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);
                }
            },
            error: function (err) {
                Error_Msg("Oops...", "Something went wrong!", "error");
                $("#bill_fatch").text('Bill Fetch Now');
                $('#bill_fatch').prop('disabled', false);
            }

        });

    }



    function billPaymentNow() {
        amount = $("#pay_amount").val();
        number = $("#filed_0").val();
        service_id = $("#service_id").val();
        provider_id = $("#provider_id").val();
        if (number == "") {
            Error_Msg("Oops...", "Please Enter Number", "error");
        } else if (provider_id == "") {
            Error_Msg("Oops...", "Please Select Provider", "error");
        } else if (amount == "") {
            Error_Msg("Oops...", "Please Enter Amount", "error");
        } else {
            $("#cd_number").text(number);
            $("#cd_provider").text($("#provider_id :selected").text());
            $("#cd_amount").text(amount);
            $('#detailsModalLabel').text('Confirm Details');
            $('#detailsModal').modal('show');
        }
    }



    function complaintView(id, order_id) {

        $("#complaintModalLabel").text("Order ID : " + order_id);

        $("#cs_id").val(id);

        $('#complaintModal').modal('show');

    }


    function complaintSubmit() {

        var id = $("#cs_id").val();

        var subject = $("#cs_subject").val();

        $("#complaint_now_btn").text('Please wait...');

        $('#complaint_now_btn').prop('disabled', true);

        $.ajax({

            url: '<?php echo e(route('serviceRechargeComplaint')); ?>',

            method: 'post',

            data: {

                id, subject,

                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function (data) {

                $("#complaint_now_btn").text('Submit');

                $('#complaint_now_btn').prop('disabled', false);

                if (data.type == "success") {

                    $('#complaintModal').modal('hide');

                    fetchAll();

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                } else {

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                }

            },

            error: function (err) {

                console.log(err);

                Error_Msg("Oops...", "Something went wrong!", "error");

                $("#complaint_now_btn").text('Submit');

                $('#complaint_now_btn').prop('disabled', false);

            }

        });

    }


    function billPaymentConfirm() {

        var number = $("#filed_0").val();

        var service_id = $("#service_id").val();

        var provider_id = $("#provider_id").val();

        var optional_1 = $("#filed_1").val();

        var optional_2 = $("#filed_2").val();

        var optional_3 = $("#filed_3").val();

        var optional_4 = $("#filed_4").val();

        var optional_5 = $("#filed_5").val();

        //var state_id = $("#state_id").val();

        var amount = $("#pay_amount").val();

        var pin = $("#t_pin").val();

        $("#bill_pay_now_btn").text('Please wait...');

        $('#bill_pay_now_btn').prop('disabled', true);

        $.ajax({

            url: '<?php echo e(route('serviceRecharge')); ?>',

            method: 'post',

            data: {

                number: number,

                service_id: service_id,

                provider_id: provider_id,

                optional_1,optional_2,optional_3,optional_4,optional_5,

                amount: amount,

                pin: pin,

                _token: '<?php echo e(csrf_token()); ?>',

            },

            success: function (data) {

                $("#bill_pay_now_btn").text('Confirm');

                $('#bill_pay_now_btn').prop('disabled', false);
                //console.log(data); 
                if (data.type == "success") {
                    if (data.status == "Success") {
                        $('#detailsModal').modal('hide');

                        Error_Msg("Success", data.remark, "success");

                        receiptView(data.id);

                        $("#pay_form")[0].reset();

                    } else if (data.status == "Failed") {

                        $('#detailsModal').modal('hide');

                        Error_Msg("Failed", data.remark, "error");

                        receiptView(data.id);

                        $("#pay_form")[0].reset();

                    } else if (data.status == "Pending") {

                        $('#detailsModal').modal('hide');

                        Error_Msg("Pending", data.remark, "info");

                        receiptView(data.id);

                        $("#pay_form")[0].reset();
                    }
                } else {

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                }

            },

            error: function (err) {

                console.log(err);

                Error_Msg("Oops...", "Something went wrong!", "error");

                $("#bill_pay_now_btn").text('Confirm');

                $('#bill_pay_now_btn').prop('disabled', false);

            }

        });

    }


    function receiptView(id) {

        $("#receipt_btn").text('Please wait...');

        $('#receipt_btn').prop('disabled', true);

        $.ajax({

            url: '<?php echo e(route('serviceRechargeGetReciept')); ?>',

            method: 'post',

            data: {

                id,

                _token: '<?php echo e(csrf_token()); ?>'

            },

            success: function (res) {

                if (res.type == "success") {

                    $("#receipt_btn").text('Receipt');

                    $('#receipt_btn').prop('disabled', false);

                    $("#rc_order_id").text(res.data.order_id);

                    $("#rc_date_time").text(res.data.created_at);

                    $("#rc_transaction_type").text(res.data.transaction_type);

                    $("#rc_remark").text(res.data.remark);

                    $("#rc_provider").text(res.provider);

                    $("#rc_status").text(res.data.status);

                    $("#rc_operator_id").text(res.data.operator_id);

                    $("#rc_amount").text("₹ " + res.data.total_amount);

                    $('#receiptModal').modal('show');

                } else {

                    Error_Msg(capitalizeFirstLetter(data.type), data.message, data.type);

                }



            }

        });

    }
</script>

<script src="<?php echo e(URL::asset('/assets/libs/prismjs/prismjs.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('/assets/libs/choices.js/choices.js.min.js')); ?>"></script>
<script src="<?php echo e(URL::asset('/assets/js/app.min.js')); ?>"></script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u440912555/domains/topservicepoint.in/public_html/resources/views/users/services/bill-payments.blade.php ENDPATH**/ ?>