<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Session;
class AdminReportsController extends Controller
{
    public function liveRechargeReports(Request $post)
    {
        ///return Session::get('login_key');
        return view('admin.admin-reports.live-recharge-report');
    }
    public function liveRechargeReportsList(Request $post)
    {

        $table = "reports";
        $reports = DB::table($table)
        ->whereIn('transaction_type',['Recharge'])
        ->orderBy('id', 'DESC')->take(25)->get();
        //echo "<pre>";print_r($reports);die;
        $output = '';
		if ($reports->count() > 0) {
            $i=1;
			foreach ($reports as $list) {
                if($list->status == "Success"){
                    $bg = "#096809";
                }elseif ($list->status == "Failed") {
                    $bg = "#d74141";
                }elseif ($list->status == "Refunded" || $list->status == "Refund") {
                    $bg = "#3231a9";
                }else{
                    $bg = "#c1680c";
                }

                $provider = DB::table('providers')->where('id', $list->provider_id)->first();
                $service = DB::table('services')->where('id', $list->service_id)->first();
                $user = DB::table('users')->where('id', $list->user_id)->first();
                $api = DB::table('apis')->where('id', $list->api_id)->first();

				$output .= '<tr style="background-color: ' . $bg . ';">
                <td>' . $i . '</td>
                <td>' . $list->transaction_date . '</td>
                <td>' . $user->mobile_number . ' - ' . $user->first_name . ' - ' . $user->outlet_name . ' </td>
                <td>' . $provider->provider_name . '</td>
                <td>' .  strtoupper($service->service_name) . '</td>
                <td>' . $list->number . '</td>
                <td>' . $api->api_name . '</td>
                <td>' . strtoupper($list->path) . '</td>
                <td>' . $list->order_id . '</td>
                <td>' . $list->operator_id . '</td>
                <td>₹' . $list->amount . '</td>
                <td>₹' . $list->commission . '</td>
                <td>₹' . $list->total_amount . '</td>
                <td>₹' . $list->opening_balance . '</td>
                <td>₹' . $list->closing_balance . '</td>
                <td>' . strtoupper($list->status) . '</td>
              </tr>';
              $i++;
			}
			echo $output;
		} else {
			echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
		}
    }


    public function userSaleReports(Request $post)
    {
        return view('admin.admin-reports.user-sale-report');
    }


    public function userSaleReportsList(Request $post) {
            $start_date2 = Carbon::now()->format('Y-m-d').' 00:00:00';
            $end_date2 = Carbon::now()->format('Y-m-d').' 23:59:59';
            $where = "";
            if($post->from_date){
                $start_date2 = $post->from_date.' 00:00:00';
                $end_date2 = $post->to_date.' 23:59:59';
                if($post->user_id!=0){
                    $where = " AND u.id = '".$post->user_id."'"; 
                }
            }
            // echo "<pre>";print_r($start_date2);//die;
            // echo "<pre>";print_r($end_date2);die;
            $query2 =  "SELECT 
            u.outlet_name, 
            u.mobile_number,
            r.user_id as id,    
            COUNT(IF(r.status = 'Pending', 1, NULL)) 'PendingHit',
            COUNT(IF(r.status = 'Failed', 1, NULL)) 'FailedHit',
            COUNT(IF(r.status = 'Success', 1, NULL)) 'SuccessHit',
            COUNT(IF(r.status = 'Refunded', 1, NULL)) 'RefundedHit',
            COUNT(r.id) 'TotalHit' ,
            SUM(CASE WHEN r.status = 'Pending' THEN total_amount ELSE 0 END) PendingAmt,
            SUM(CASE WHEN r.status = 'Failed' THEN total_amount ELSE 0 END) FailedAmt,
            SUM(CASE WHEN r.status = 'Success' THEN total_amount ELSE 0 END) SuccessAmt,
            SUM(CASE WHEN r.status = 'Refunded' THEN total_amount ELSE 0 END) RefundedAmt,
            SUM(r.total_amount) 'TotalAmt',
            SUM(CASE WHEN r.status = 'Success' THEN commission ELSE 0 END) Comm
            FROM `reports` as r JOIN users as u ON u.id=r.user_id  
            WHERE r.created_at between '$start_date2' AND '$end_date2' AND transaction_type IN ('Recharge', 'Bill Pay') $where
            group by r.user_id,u.outlet_name,u.mobile_number";
           //echo "<pre>";print_r($query2);die;
            $reports = DB::select($query2);
            $output = '';
            if (count($reports) > 0) {
                $output .= '<table id="scroll-vertical" class="table table-bordered dt-responsive nowrap align-middle mdl-data-table" style="width:100%;text-transform: uppercase;">
                <thead>
                <tr>
                    <th>User Details</th>
                    <th>Qty/Total Amount</th>
                    <th>Qty/Success Amount</th>
                    <th>Qty/Failed Amount</th>
                    <th>Qty/Refunded Amount</th>
                    <th>Qty/Pending Amount</th>
                    <th>Commission</th>
                </tr>
                </thead>
                <tbody>';
                $i=1;
                $totalhit = 0;
                $totalamt = 0;
                $successhit = 0;
                $successamt = 0;
                $failedhit = 0;
                $failedamt = 0;
                $refundedhit = 0;
                $frefundedamt = 0;
                $pendingamt = 0;
                $pendinghit = 0;
                $totalcomm = 0;
                foreach ($reports as $list) {
                    $output .= '<tr>
                        <td class="text-center font-weight-bold">' . $list->outlet_name . ' - ' . $list->mobile_number . ' (' . $list->id . ')</td>
                        <td class="text-center font-weight-bold">' . $list->TotalHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->TotalAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->SuccessHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->SuccessAmt, 2). '</td>
                        <td class="text-center font-weight-bold">' . $list->FailedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->FailedAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->RefundedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->RefundedAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->PendingHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->PendingAmt, 2) . '</td>
                        <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float) $list->Comm, 2) . '</td>
                    </tr>';
                    $totalhit +=$list->TotalHit;
                    $totalamt +=$list->TotalAmt;
                    $successhit +=$list->SuccessHit;
                    $successamt +=$list->SuccessAmt;
                    $failedhit +=$list->FailedHit;
                    $failedamt +=$list->FailedAmt;
                    $refundedhit +=$list->RefundedHit;
                    $frefundedamt +=$list->RefundedAmt;
                    $pendingamt +=$list->PendingAmt;
                    $pendinghit +=$list->PendingHit;
                    $totalcomm +=$list->Comm;
                    $i++;
                }
                $output .= '</tbody><tfoot>
                    <tr>
                        <td class="text-center font-weight-bold">Total</td>
                        <td class="text-center font-weight-bold"> ' . $totalhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$totalamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $successhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$successamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $failedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$failedamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $refundedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$frefundedamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $pendinghit . ' /<i class="las la-rupee-sign"></i>  ' . number_format((float)$pendingamt, 2) . '</td>
                        <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float)$totalcomm, 2) . '</td>
                    </tr>
                </tfoot>';
                $output .= '</table>';
                return $output;
                //echo '<h4 class="text-center text-secondary my-3">record found</h4>';
            }else{
                echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
            }
        //return $reports;
    }



    public function mdAndDtSaleReports(Request $post)
    {
        return view('admin.admin-reports.md-dt-sale-report');
    }


    public function mdAndDtSaleReportsList(Request $post) {
            $start_date2 = Carbon::now()->format('Y-m-d').' 00:00:00';
            $end_date2 = Carbon::now()->format('Y-m-d').' 23:59:59';
            $where = "";
            if($post->from_date){
                $start_date2 = $post->from_date.' 00:00:00';
                $end_date2 = $post->to_date.' 23:59:59';
                if($post->user_id!=0){
                    $where = " AND u.id = '".$post->user_id."'"; 
                }
            }
            // echo "<pre>";print_r($start_date2);//die;
            // echo "<pre>";print_r($end_date2);die;
            $query2 =  "SELECT 
            u.outlet_name, 
            u.mobile_number,
            r.user_id as id,    
            COUNT(IF(r.status = 'Pending', 1, NULL)) 'PendingHit',
            COUNT(IF(r.status = 'Failed', 1, NULL)) 'FailedHit',
            COUNT(IF(r.status = 'Success', 1, NULL)) 'SuccessHit',
            COUNT(IF(r.status = 'Refunded', 1, NULL)) 'RefundedHit',
            COUNT(r.id) 'TotalHit' ,
            SUM(CASE WHEN r.status = 'Pending' THEN total_amount ELSE 0 END) PendingAmt,
            SUM(CASE WHEN r.status = 'Failed' THEN total_amount ELSE 0 END) FailedAmt,
            SUM(CASE WHEN r.status = 'Success' THEN total_amount ELSE 0 END) SuccessAmt,
            SUM(CASE WHEN r.status = 'Refunded' THEN total_amount ELSE 0 END) RefundedAmt,
            SUM(r.total_amount) 'TotalAmt',
            SUM(CASE WHEN r.status = 'Success' THEN commission ELSE 0 END) Comm
            FROM `reports` as r JOIN users as u ON u.id=r.user_id  
            WHERE r.created_at between '$start_date2' AND '$end_date2' AND transaction_type IN ('Commission') $where
            group by r.user_id,u.outlet_name,u.mobile_number";
           //echo "<pre>";print_r($query2);die;
            $reports = DB::select($query2);
            $output = '';
            if (count($reports) > 0) {
                $output .= '<table id="scroll-vertical" class="table table-bordered dt-responsive nowrap align-middle mdl-data-table" style="width:100%;text-transform: uppercase;">
                <thead>
                <tr>
                    <th>User Details</th>
                    <th>Qty/Total Amount</th>
                    <th>Qty/Success Amount</th>
                    <th>Qty/Failed Amount</th>
                    <th>Qty/Refunded Amount</th>
                    <th>Qty/Pending Amount</th>
                    <th>Commission</th>
                </tr>
                </thead>
                <tbody>';
                $i=1;
                $totalhit = 0;
                $totalamt = 0;
                $successhit = 0;
                $successamt = 0;
                $failedhit = 0;
                $failedamt = 0;
                $refundedhit = 0;
                $frefundedamt = 0;
                $pendingamt = 0;
                $pendinghit = 0;
                $totalcomm = 0;
                foreach ($reports as $list) {
                    $output .= '<tr>
                        <td class="text-center font-weight-bold">' . $list->outlet_name . ' - ' . $list->mobile_number . ' (' . $list->id . ')</td>
                        <td class="text-center font-weight-bold">' . $list->TotalHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->TotalAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->SuccessHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->SuccessAmt, 2). '</td>
                        <td class="text-center font-weight-bold">' . $list->FailedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->FailedAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->RefundedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->RefundedAmt, 2) . '</td>
                        <td class="text-center font-weight-bold">' . $list->PendingHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->PendingAmt, 2) . '</td>
                        <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float) $list->Comm, 2) . '</td>
                    </tr>';
                    $totalhit +=$list->TotalHit;
                    $totalamt +=$list->TotalAmt;
                    $successhit +=$list->SuccessHit;
                    $successamt +=$list->SuccessAmt;
                    $failedhit +=$list->FailedHit;
                    $failedamt +=$list->FailedAmt;
                    $refundedhit +=$list->RefundedHit;
                    $frefundedamt +=$list->RefundedAmt;
                    $pendingamt +=$list->PendingAmt;
                    $pendinghit +=$list->PendingHit;
                    $totalcomm +=$list->Comm;
                    $i++;
                }
                $output .= '</tbody><tfoot>
                    <tr>
                        <td class="text-center font-weight-bold">Total</td>
                        <td class="text-center font-weight-bold"> ' . $totalhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$totalamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $successhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$successamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $failedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$failedamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $refundedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$frefundedamt, 2) . '</td>
                        <td class="text-center font-weight-bold"> ' . $pendinghit . ' /<i class="las la-rupee-sign"></i>  ' . number_format((float)$pendingamt, 2) . '</td>
                        <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float)$totalcomm, 2) . '</td>
                    </tr>
                </tfoot>';
                $output .= '</table>';
                return $output;
                //echo '<h4 class="text-center text-secondary my-3">record found</h4>';
            }else{
                echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
            }
        //return $reports;
    }


    public function providerSaleReports(Request $post)
    {
        return view('admin.admin-reports.provider-sale-report');
    }


    public function providerSaleReportsList(Request $post) {
        $start_date2 = Carbon::now()->format('Y-m-d').' 00:00:00';
        $end_date2 = Carbon::now()->format('Y-m-d').' 23:59:59';
        $where = "";
        if($post->from_date){
            $start_date2 = $post->from_date.' 00:00:00';
            $end_date2 = $post->to_date.' 23:59:59';
            if($post->user_id!=0){
                $where = " AND u.id = '".$post->user_id."'"; 
            }
        }
        // echo "<pre>";print_r($start_date2);//die;
        // echo "<pre>";print_r($end_date2);die;
        $query2 =  "SELECT 
        p.provider_name,
        s.service_name,
        r.user_id as id,    
        COUNT(IF(r.status = 'Pending', 1, NULL)) 'PendingHit',
        COUNT(IF(r.status = 'Failed', 1, NULL)) 'FailedHit',
        COUNT(IF(r.status = 'Success', 1, NULL)) 'SuccessHit',
        COUNT(IF(r.status = 'Refunded', 1, NULL)) 'RefundedHit',
        COUNT(r.id) 'TotalHit' ,
        SUM(CASE WHEN r.status = 'Pending' THEN total_amount ELSE 0 END) PendingAmt,
        SUM(CASE WHEN r.status = 'Failed' THEN total_amount ELSE 0 END) FailedAmt,
        SUM(CASE WHEN r.status = 'Success' THEN total_amount ELSE 0 END) SuccessAmt,
        SUM(CASE WHEN r.status = 'Refunded' THEN total_amount ELSE 0 END) RefundedAmt,
        SUM(r.total_amount) 'TotalAmt',
        SUM(CASE WHEN r.status = 'Success' THEN commission ELSE 0 END) Comm
        FROM `reports` as r 
        JOIN services as s ON s.id=r.service_id 
        JOIN users as u ON u.id=r.user_id 
        JOIN providers as p ON p.id=r.provider_id 
        WHERE r.created_at between '$start_date2' AND '$end_date2' AND transaction_type IN ('Recharge', 'Bill Pay') $where
        group by p.provider_name,r.user_id,s.service_name";
       //echo "<pre>";print_r($query2);die;
        $reports = DB::select($query2);
        $output = '';
        if (count($reports) > 0) {
            $output .= '<table id="scroll-vertical" class="table table-bordered dt-responsive nowrap align-middle mdl-data-table" style="width:100%;text-transform: uppercase;">
            <thead>
            <tr>
                <th>Provider Details</th>
                <th>Qty/Total Amount</th>
                <th>Qty/Success Amount</th>
                <th>Qty/Failed Amount</th>
                <th>Qty/Refunded Amount</th>
                <th>Qty/Pending Amount</th>
                <th>Commission</th>
            </tr>
            </thead>
            <tbody>';
            $i=1;
            $totalhit = 0;
            $totalamt = 0;
            $successhit = 0;
            $successamt = 0;
            $failedhit = 0;
            $failedamt = 0;
            $refundedhit = 0;
            $frefundedamt = 0;
            $pendingamt = 0;
            $pendinghit = 0;
            $totalcomm = 0;
            foreach ($reports as $list) {
                $output .= '<tr>
                    <td class="text-center font-weight-bold">' . $list->provider_name . ' - ' . $list->service_name . '</td>
                    <td class="text-center font-weight-bold">' . $list->TotalHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->TotalAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->SuccessHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->SuccessAmt, 2). '</td>
                    <td class="text-center font-weight-bold">' . $list->FailedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->FailedAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->RefundedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->RefundedAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->PendingHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->PendingAmt, 2) . '</td>
                    <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float) $list->Comm, 2) . '</td>
                </tr>';
                $totalhit +=$list->TotalHit;
                $totalamt +=$list->TotalAmt;
                $successhit +=$list->SuccessHit;
                $successamt +=$list->SuccessAmt;
                $failedhit +=$list->FailedHit;
                $failedamt +=$list->FailedAmt;
                $refundedhit +=$list->RefundedHit;
                $frefundedamt +=$list->RefundedAmt;
                $pendingamt +=$list->PendingAmt;
                $pendinghit +=$list->PendingHit;
                $totalcomm +=$list->Comm;
                $i++;
            }
            $output .= '</tbody><tfoot>
                <tr>
                    <td class="text-center font-weight-bold">Total</td>
                    <td class="text-center font-weight-bold"> ' . $totalhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$totalamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $successhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$successamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $failedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$failedamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $refundedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$frefundedamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $pendinghit . ' /<i class="las la-rupee-sign"></i>  ' . number_format((float)$pendingamt, 2) . '</td>
                    <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float)$totalcomm, 2) . '</td>
                </tr>
            </tfoot>';
            $output .= '</table>';
            return $output;
            //echo '<h4 class="text-center text-secondary my-3">record found</h4>';
        }else{
            echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
        }
    }

    public function apiSaleReports(Request $post)
    {
        return view('admin.admin-reports.api-sale-report');
    }

    public function apiList()
    {
        $apis = DB::table('apis')->select('id','api_name')->where('deleted_at', '!=' , 1)->where('status',1)->get();
        if($apis){
            $data['type'] = 'success';
            $data['message'] = "Get sucessfuly";
            $data['apis'] = $apis;
        } else {
            $data['type'] = 'error';
            $data['message'] = "Something went wrong!";
        }
        return $data;
    }

    public function apiSaleReportsList(Request $post) {
        $start_date2 = Carbon::now()->format('Y-m-d').' 00:00:00';
        $end_date2 = Carbon::now()->format('Y-m-d').' 23:59:59';
        $where = "";
        if($post->from_date){
            $start_date2 = $post->from_date.' 00:00:00';
            $end_date2 = $post->to_date.' 23:59:59';
            if($post->user_id!=0){
                $where = " AND a.id = '".$post->api_id."'"; 
            }
        }
        // echo "<pre>";print_r($start_date2);//die;
        // echo "<pre>";print_r($end_date2);die;
        $query2 =  "SELECT 
        a.api_name,
        COUNT(IF(r.status = 'Pending', 1, NULL)) 'PendingHit',
        COUNT(IF(r.status = 'Failed', 1, NULL)) 'FailedHit',
        COUNT(IF(r.status = 'Success', 1, NULL)) 'SuccessHit',
        COUNT(IF(r.status = 'Refunded', 1, NULL)) 'RefundedHit',
        COUNT(r.id) 'TotalHit' ,
        SUM(CASE WHEN r.status = 'Pending' THEN total_amount ELSE 0 END) PendingAmt,
        SUM(CASE WHEN r.status = 'Failed' THEN total_amount ELSE 0 END) FailedAmt,
        SUM(CASE WHEN r.status = 'Success' THEN total_amount ELSE 0 END) SuccessAmt,
        SUM(CASE WHEN r.status = 'Refunded' THEN total_amount ELSE 0 END) RefundedAmt,
        SUM(r.total_amount) 'TotalAmt',
        SUM(CASE WHEN r.status = 'Success' THEN commission ELSE 0 END) Comm
        FROM `reports` as r JOIN users as u ON u.id=r.user_id 
        JOIN apis as a ON a.id=r.api_id   
        WHERE r.created_at between '$start_date2' AND '$end_date2' AND transaction_type IN ('Recharge', 'Bill Pay') $where
        group by a.api_name";
       //echo "<pre>";print_r($query2);die;
        $reports = DB::select($query2);
        $output = '';
        if (count($reports) > 0) {
            $output .= '<table id="scroll-vertical" class="table table-bordered dt-responsive nowrap align-middle mdl-data-table" style="width:100%;text-transform: uppercase;">
            <thead>
            <tr>
                <th>API Details</th>
                <th>Qty/Total Amount</th>
                <th>Qty/Success Amount</th>
                <th>Qty/Failed Amount</th>
                <th>Qty/Refunded Amount</th>
                <th>Qty/Pending Amount</th>
                <th>Commission</th>
            </tr>
            </thead>
            <tbody>';
            $i=1;
            $totalhit = 0;
            $totalamt = 0;
            $successhit = 0;
            $successamt = 0;
            $failedhit = 0;
            $failedamt = 0;
            $refundedhit = 0;
            $frefundedamt = 0;
            $pendingamt = 0;
            $pendinghit = 0;
            $totalcomm = 0;
            foreach ($reports as $list) {
                $output .= '<tr>
                    <td class="text-center font-weight-bold">' . $list->api_name . '</td>
                    <td class="text-center font-weight-bold">' . $list->TotalHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->TotalAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->SuccessHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->SuccessAmt, 2). '</td>
                    <td class="text-center font-weight-bold">' . $list->FailedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->FailedAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->RefundedHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->RefundedAmt, 2) . '</td>
                    <td class="text-center font-weight-bold">' . $list->PendingHit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float) $list->PendingAmt, 2) . '</td>
                    <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float) $list->Comm, 2) . '</td>
                </tr>';
                $totalhit +=$list->TotalHit;
                $totalamt +=$list->TotalAmt;
                $successhit +=$list->SuccessHit;
                $successamt +=$list->SuccessAmt;
                $failedhit +=$list->FailedHit;
                $failedamt +=$list->FailedAmt;
                $refundedhit +=$list->RefundedHit;
                $frefundedamt +=$list->RefundedAmt;
                $pendingamt +=$list->PendingAmt;
                $pendinghit +=$list->PendingHit;
                $totalcomm +=$list->Comm;
                $i++;
            }
            $output .= '</tbody><tfoot>
                <tr>
                    <td class="text-center font-weight-bold">Total</td>
                    <td class="text-center font-weight-bold"> ' . $totalhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$totalamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $successhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$successamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $failedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$failedamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $refundedhit . ' / <i class="las la-rupee-sign"></i> ' . number_format((float)$frefundedamt, 2) . '</td>
                    <td class="text-center font-weight-bold"> ' . $pendinghit . ' /<i class="las la-rupee-sign"></i>  ' . number_format((float)$pendingamt, 2) . '</td>
                    <td class="text-center font-weight-bold"><i class="las la-rupee-sign"></i> ' . number_format((float)$totalcomm, 2) . '</td>
                </tr>
            </tfoot>';
            $output .= '</table>';
            return $output;
            //echo '<h4 class="text-center text-secondary my-3">record found</h4>';
        }else{
            echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
        }
    }


    public function apiLogReports(Request $post)
    {
        return view('admin.admin-reports.api-log-report');
    }


    public function apiLogReportsList(Request $post)
    {
        $rules = array(
            'page' => 'required|numeric',
            'limit' => 'required|numeric',
        );

        $validator = \Validator::make($post->all(), array_reverse($rules));
        if ($validator->fails()) {
            foreach ($validator->errors()->messages() as $key => $value) {
                $error = $value[0];
            }
            return '<h4 class="text-center text-secondary my-3">'.$error.'</h4>';
        }

        if($post->page){
            $page = $post->page; 
        }else{
            $page = 1; 
        }

        if($post->limit){
            if($post->limit <= 50){
                $limit = $post->limit; 
            }else{
                $limit = 10;  
            }
        }else{
            $limit = 10; 
        }
        if($post->from_date){
            $from_date = $post->from_date." 00:00:00";
            $to_date = $post->to_date." 23:59:59";
            $table = "apilogs";
        }else{
            $from_date = Carbon::today()->format('Y-m-d')." 00:00:00";
            $to_date = Carbon::today()->format('Y-m-d')." 23:59:59";
            $table = "apilogs";
        }
        
        $start= ($page-1) * $limit;
        $total_row = DB::table($table)
            ->whereBetween('created_at', [$from_date,$to_date])
            ->where('txnid', 'like', '%' . $post->order_id . '%')
            ->orderBy('id', 'DESC')
            ->get();
        $total_row_count = $total_row->count();
        $total_pages = ceil($total_row_count / $limit);
        $page_link = '';
        for ($i1=1; $i1<=$total_pages; $i1++) {
            if($page == $i1){
                $act = "active";
                $d = "";
            }else{
                $act = "";
                $d = 'onclick="tableSearch('.$i1.')"';
            }
            $page_link .= '<li class="page-item "><a href="javascript:void(0)" class="page-link '.$act.'" '.$d.'>'.$i1.'</a></li>';
        };
        //$transaction_type = "'Transfer Money'";
        
        $list = DB::table($table)
            ->whereBetween('created_at', [$from_date,$to_date])
            ->where('txnid', 'like', '%' . $post->order_id . '%')
            ->orderBy('id', 'DESC')
            ->offset($start)
            ->limit($limit)
            ->get();
        $list_count = $list->count();
        $output = '';
		if ($list->count() > 0) {
			$output .= '<div class="table-responsive">';
            $output .= '<div class="row">
                    <div class="col-sm-1">
                        <select class="form-select mb-3 page_limit" aria-label="Page Limit" id="page_limit">
                            <option ' . ($limit == "5" ? "selected" : "") . ' value="5">5</option>
                            <option ' . ($limit == "10" ? "selected" : "") . ' value="10" >10</option>
                            <option ' . ($limit == "15" ? "selected" : "") . ' value="15">15</option>
                            <option ' . ($limit == "25" ? "selected" : "") . ' value="25">25</option>
                            <option ' . ($limit == "50" ? "selected" : "") . ' value="50">50</option>
                        </select>
                    </div>
                    <div class="col-sm-9">
                        </br>
                    </div>
                    
                    <div class="col-sm-2">
                        <input type="text" class="form-control" id="searchValueTable" placeholder="Enter Search Value">
                    </div>
                </div><br>';
            $output .= '<table class="table table-bordered table-nowrap" id="pagination_table"><thead>
              <tr>
                <th>ID</th>
                <th>Order Id</th>
                <th>Date & Time</th>
                <th>Req Type</th>
                <th>Req Url</th>
                <th>Req Header</th>
                <th>Req Post</th>
                <th>Response</th>
              </tr>
            </thead>
            <tbody>';
            $i=$start + 1;
			foreach ($list as $list) {
				$output .= '<tr>
                <td>' . $i . '</td>
                <td>' . $list->txnid . '</td>
                <td>' . $list->created_at . '</td>
                <td>' . $list->modal . '</td>
                <td>' . $list->url . '</td>
                <td>' . $list->header . '</td>
                <td>' . $list->request . '</td>
                <td>' . $list->response . '</td>
              </tr>';
              $i++;
			}
			$output .= '</tbody></table>';
			$output .= '<div class="row">
                <div class="col-sm-2">
                        <span>Showing '.($start + 1).' to '.($start + $list_count).' of '.$list_count.' entries ('.$total_row_count.' entries)</span>
                </div>
                <div class="col-sm-6">
                <br>
                </div>
                <div class="col-sm-4">
                        <nav aria-label="Page navigation example">
                        <ul class="pagination">
                            <li class="page-item '.($page  == 1 || $page  == 0 ? "disabled" : "").'">
                                <a class="page-link" href="javascript:void(0)" onclick="tableSearch('.($page - 1).')">← &nbsp; Prev</a>
                            </li>
                                '.$page_link.'
                            <li class="page-item '.($page + 1 == $i1 ? "disabled" : "").'">
                                <a class="page-link" href="javascript:void(0)" onclick="tableSearch('.($page + 1 == $i1 ? $page : $page + 1).')">Next &nbsp; →</a>
                            </li>
                        </ul>
                    </nav>
                </div>
            </div><br>';

            $output .= '</div>';
            echo $output;
		} else {
			echo '<h4 class="text-center text-secondary my-3">No record found</h4>';
		}
    }





}
