<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Redirect;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Session;
class ProfileController extends Controller
{

    public function Logout(Request $post)
    {
        $post->session()->flush();
        return redirect('admin/login');
    }

    public function myProfile(Request $post)
    {
        return view('admin.profile.my-profile');
    }

    public function myProfileData(Request $post)
    {

        $user = DB::table('users')
        ->select(
            'first_name',
            'middle_name',
            'last_name',
            'outlet_name',
            'date_of_birth',
            'email_address',
            'mobile_number',
            'city',
            'state',
            'district',
            'minium_balance',
            'wallet_balance',
            'profile_pic',
            'kyc_status',
            'minium_balance',
            'callback_url',
            'ip_address',
            'role_name',
        )
        ->join('roles', 'users.role_id', '=', 'roles.id')
        ->where('users.id',Session::get('user_id'))
        ->first();
        $login_history = DB::table('login_histories')
        ->where("user_id",Session::get('user_id'))
        
        ->take(5)
        ->orderBy('id', 'DESC')
        ->get(['ip_address','login_path','created_at']);

        $company =  DB::table('companies')
        ->select('company_logo','company_icon','invoice_logo','company_name','support_number','support_number_2','support_email','company_address')
        ->where('status', "1")
        ->where('domain', $_SERVER['HTTP_HOST'])
        ->first();

        $announcements = DB::table('announcements')
        ->select('message')
        ->where('id',1)
        ->first()->message;
        if($user){
            $data['type'] = 'success';
            $data['message'] = "Fatch Sucessfuly";
            $data['data']['user'] = $user;
            $data['data']['login_history'] = $login_history;
            $data['data']['company'] = $company;
            $data['data']['announcements'] = $announcements;
        }else{
            $data['type'] = 'error';
            $data['message'] = "Something went wrong!";
        }

        return $data;
    }


    public function myProfilePasswordChange(Request $post) {
        $rules = array(
            'current_password' => 'required|min:8',
            'new_password' => 'required|min:8',
            'confirm_password' => 'required|same:new_password|min:8',
        );

        $validator = \Validator::make($post->all(), array_reverse($rules));
        if ($validator->fails()) {
            foreach ($validator->errors()->messages() as $key => $value) {
                $error = $value[0];
            }
            return response()->json(array(
                'type' => 'error',  
                'message' => $error
            ));
        }

        $user = DB::table('users')->where("id",Session::get('user_id'))->where("role_id",1)->first();
        if(Hash::check($post->current_password, $user->password)){
            $password = Hash::make($post->confirm_password);
            $user = DB::table('users')->where('id', $user->id)->update(['password' => $password]);
            if($user){
                return response()->json(array(
                    'type' => 'success',  
                    'message' => "Password Change Successfuly."
                ));
            }else{
                return response()->json(array(
                    'type' => 'error',  
                    'message' => "Something went wrong."
                ));
            }
        }else{
            $data['type'] = 'error';
            $data['message'] = "Current password do not match.";
        }
        return $data;
    }

}
