/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Context;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConfigXmlParser {
    private static String TAG = "ConfigXmlParser";
    private static String SCHEME_HTTP = "http";
    private static String SCHEME_HTTPS = "https";
    private static String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_CONTENT_SRC = "index.html";
    private String launchUrl;
    private String contentSrc;
    private CordovaPreferences prefs = new CordovaPreferences();
    private ArrayList<PluginEntry> pluginEntries = new ArrayList(20);
    boolean insideFeature = false;
    String service = "";
    String pluginClass = "";
    String paramType = "";
    boolean onload = false;

    public CordovaPreferences getPreferences() {
        return this.prefs;
    }

    public ArrayList<PluginEntry> getPluginEntries() {
        return this.pluginEntries;
    }

    public String getLaunchUrl() {
        if (this.launchUrl == null) {
            this.setStartUrl(this.contentSrc);
        }
        return this.launchUrl;
    }

    public void parse(Context action) {
        int id = action.getResources().getIdentifier("config", "xml", action.getClass().getPackage().getName());
        if (id == 0 && (id = action.getResources().getIdentifier("config", "xml", action.getPackageName())) == 0) {
            LOG.e(TAG, "res/xml/config.xml is missing!");
            return;
        }
        this.pluginEntries.add(new PluginEntry("CordovaAllowListPlugin", "org.apache.cordova.AllowListPlugin", true));
        this.pluginEntries.add(new PluginEntry("CordovaSplashScreenPlugin", "org.apache.cordova.SplashScreenPlugin", true));
        this.parse((XmlPullParser)action.getResources().getXml(id));
    }

    public void parse(XmlPullParser xml) {
        int eventType = -1;
        while (eventType != 1) {
            if (eventType == 2) {
                this.handleStartTag(xml);
            } else if (eventType == 3) {
                this.handleEndTag(xml);
            }
            try {
                eventType = xml.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.onPostParse();
    }

    private void onPostParse() {
        if (this.contentSrc == null) {
            this.contentSrc = DEFAULT_CONTENT_SRC;
        }
    }

    public void handleStartTag(XmlPullParser xml) {
        String strNode = xml.getName();
        if (strNode.equals("feature")) {
            this.insideFeature = true;
            this.service = xml.getAttributeValue(null, "name");
        } else if (this.insideFeature && strNode.equals("param")) {
            this.paramType = xml.getAttributeValue(null, "name");
            if (this.paramType.equals("service")) {
                this.service = xml.getAttributeValue(null, "value");
            } else if (this.paramType.equals("package") || this.paramType.equals("android-package")) {
                this.pluginClass = xml.getAttributeValue(null, "value");
            } else if (this.paramType.equals("onload")) {
                this.onload = "true".equals(xml.getAttributeValue(null, "value"));
            }
        } else if (strNode.equals("preference")) {
            String name = xml.getAttributeValue(null, "name").toLowerCase(Locale.ENGLISH);
            String value = xml.getAttributeValue(null, "value");
            this.prefs.set(name, value);
        } else if (strNode.equals("content")) {
            String src = xml.getAttributeValue(null, "src");
            this.contentSrc = src != null ? src : DEFAULT_CONTENT_SRC;
        }
    }

    public void handleEndTag(XmlPullParser xml) {
        String strNode = xml.getName();
        if (strNode.equals("feature")) {
            this.pluginEntries.add(new PluginEntry(this.service, this.pluginClass, this.onload));
            this.service = "";
            this.pluginClass = "";
            this.insideFeature = false;
            this.onload = false;
        }
    }

    private String getLaunchUrlPrefix() {
        if (this.prefs.getBoolean("AndroidInsecureFileModeEnabled", false)) {
            return "file:///android_asset/www/";
        }
        String scheme = this.prefs.getString("scheme", SCHEME_HTTPS).toLowerCase();
        String hostname = this.prefs.getString("hostname", DEFAULT_HOSTNAME).toLowerCase();
        if (!scheme.contentEquals(SCHEME_HTTP) && !scheme.contentEquals(SCHEME_HTTPS)) {
            LOG.d(TAG, "The provided scheme \"" + scheme + "\" is not valid. Defaulting to \"" + SCHEME_HTTPS + "\". (Valid Options=" + SCHEME_HTTP + "," + SCHEME_HTTPS + ")");
            scheme = SCHEME_HTTPS;
        }
        return scheme + "://" + hostname + '/';
    }

    private void setStartUrl(String src) {
        Pattern schemeRegex = Pattern.compile("^[a-z-]+://");
        Matcher matcher = schemeRegex.matcher(src);
        if (matcher.find()) {
            this.launchUrl = src;
        } else {
            String launchUrlPrefix = this.getLaunchUrlPrefix();
            if (src.charAt(0) == '/') {
                src = src.substring(1);
            }
            this.launchUrl = launchUrlPrefix + src;
        }
    }
}

