
///Setup App Config Start
let BASE_URL = "https://bbps.gurupays.com/api/v1/";
let ADMIN_URL = "https://bbps-admin.gurupays.com/";
let PAY_URL = "https://bbps.gurupays.com/";
let APP_NAME = "Payzeer Wallet";
///Setup App Config End


dateFormat = (v, chk = 0) => {
	if (v) {
		if (chk == 0) var today = new Date(v);
		else var today = v;
		var dd = today.getDate();
		var mm = today.getMonth() + 1;
		var yyyy = today.getFullYear();
		if (dd < 10) {
			dd = "0" + dd;
		}
		if (mm < 10) {
			mm = "0" + mm;
		}
		if (chk == 1) return yyyy + "-" + mm + "-" + dd;
		else return mm + "/" + dd + "/" + yyyy;
	}
};
ucFirst = (string) => {
	return string.charAt(0).toUpperCase() + string.slice(1);
};


if (PAGE == "LOGIN_PAGE") {

	$('#loader').hide();
	function loginCheck() {
		//e.preventDefault();
		var mobile = $("#mobile_l").val();
		var password = $("#password").val();
		if (mobile == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (password == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter password");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'login',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					mobile_number: mobile,
					password: password
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'otp_verify') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);

						$("#login_from").hide();
						$("#otp_verify").show();
						$("#login_otp_btn").show();
					} else if (res.type == 'success') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);

						localStorage.setItem("islogin", 1);
						localStorage.setItem("id", res.data.user_id);
						localStorage.setItem("role_id", res.data.role_id);
						localStorage.setItem("parent_id", res.data.parent_id);
						localStorage.setItem("login_key", res.data.login_key);
						localStorage.setItem("states", JSON.stringify(res.data.states));
						localStorage.setItem("mobile_provider", JSON.stringify(res.data.mobile_provider));
						localStorage.setItem("postpaid_provider", JSON.stringify(res.data.postpaid_provider));
						localStorage.setItem("dth_provider", JSON.stringify(res.data.dth_provider));
						window.location.replace('home.html');
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function loginVerifyOtp() {
		//e.preventDefault();
		var mobile = $("#mobile_l").val();
		var password = $("#password").val();
		var otp = $("#input_otp").val();
		if (mobile == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (password == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter password");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'login-otp',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					mobile_number: mobile,
					password: password,
					otp: otp
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						localStorage.setItem("islogin", 1);
						localStorage.setItem("id", res.data.user_id);
						localStorage.setItem("role_id", res.data.role_id);
						localStorage.setItem("parent_id", res.data.parent_id);
						localStorage.setItem("login_key", res.data.login_key);
						localStorage.setItem("states", JSON.stringify(res.data.states));
						localStorage.setItem("mobile_provider", JSON.stringify(res.data.mobile_provider));
						localStorage.setItem("postpaid_provider", JSON.stringify(res.data.postpaid_provider));
						localStorage.setItem("dth_provider", JSON.stringify(res.data.dth_provider));
						window.location.replace('home.html');
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function resetPassword() {
		//e.preventDefault();
		var mobile = $("#mobile_l").val();
		if (mobile == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'reset-password',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					mobile_number: mobile
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'otp_verify') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						$("#login_from").hide();
						$("#otp_verify").show();
						$("#otp_btn").attr("onclick", "resetPasswordVerifyOtp()");
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}


	function resetPasswordVerifyOtp() {
		//e.preventDefault();
		var mobile = $("#mobile_l").val();
		var otp = $("#input_otp").val();
		if (mobile == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (otp == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter otp");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'reset-password-otp',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					mobile_number: mobile,
					otp: otp
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$("#login_from").show();
						$("#otp_verify").hide();
						$("#otp_btn").attr("onclick", "loginVerifyOtp()");
						$(".otp__digit").val("");
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}
} else if (PAGE == "HOME_PAGE") {

	if (localStorage.getItem("role_id") == 6) {
		$('#rech_div').show();
		$('#bill_pay_div').show();
		$('#banking_div').show();
	} else {
		$('#manage_user_div').show();
	}

	function pravacyPolicy() {
		var inAppBrowserRef;
		function openInAppBrowser() {
			inAppBrowserRef = cordova.InAppBrowser.open(PAY_URL + "privacy-policy", '_self', "location=no,zoom=no,toolbarcolor=#00ff00");
		}
		openInAppBrowser();
	}

	function termCondition() {
		var inAppBrowserRef;
		function openInAppBrowser() {
			inAppBrowserRef = cordova.InAppBrowser.open(PAY_URL + "term-and-condition", '_self', "location=no,zoom=no,toolbarcolor=#00ff00");
		}
		openInAppBrowser();
	}

	function RefundandCancellation() {
		var inAppBrowserRef;
		function openInAppBrowser() {
			inAppBrowserRef = cordova.InAppBrowser.open(PAY_URL + "refunds", '_self', "location=no,zoom=no,toolbarcolor=#00ff00");
		}
		openInAppBrowser();
	}

	function logOutConfirm() {
		localStorage.clear();
		window.location.replace("login.html");
	}

	function homeSupport() {
		var company = JSON.parse(localStorage.getItem("company_data"));
		$('#DialogBasic').modal('show');
		$("#alert_error").text("Support Details");
		$("#alert_error_msg").html(
			'<ul class="list-group">' +
			'<li class="list-group-item d-flex justify-content-between align-items-center" style="padding: 20px;">' +
			'<img src="assets/img/ui_icons/whatsapp.png" class="h_icon"> WhatsApp' +
			'<a style="font-weight: bold;" href="whatsapp://send/?phone=+91' + company.support_number.replace('+91-', '') + '&text=help me please">' + company.support_number.replace('+91-', '') + '</a>' +
			'</li>' +
			'<li class="list-group-item d-flex justify-content-between align-items-center" style="padding: 20px;"><img src="assets/img/ui_icons/call-now.png" class="h_icon"> Call Now<a style="font-weight: bold;" href="tel:91' + company.support_number.replace('+91-', '') + '">' + company.support_number.replace('+91-', '') + '</a></li>' +
			'<li class="list-group-item d-flex justify-content-between align-items-center" style="padding: 20px;"><img src="assets/img/ui_icons/mail.png" class="h_icon"> Email<a style="font-weight: bold;" href="mailto:' + company.support_email + '">Send Email</a></li>' +
			'<li class="list-group-item d-flex justify-content-between align-items-center" style="padding: 20px;"><img src="assets/img/ui_icons/google-maps.png" class="h_icon"> Address <br><a style="font-weight: bold;" href="geo:' + company.company_address + '">' + company.company_address + '</a></li>' +
			'</ul>');
		$(".modal-content").css('max-width', '100%');
		///$(".modal-content").css('width','100%');
	}
	function comingSoon() {
		$('#DialogBasic').modal('show');
		$("#alert_error").text("Warning");
		$("#alert_error_msg").text("Coming Soon");
	}
	getHomeData();
	function getHomeData() {
		$.ajax({
			url: BASE_URL + 'home',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id")
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					$.each(res.sliders, function (key, data) {
						$('#carrusel').append($('<div class="carousel-item item img_' + key + '"><img class="d-block img-fluid card-img-top" style="height:150px;" src="' + res.admin_url + '/slider_image/' + data.image + '"></div>'));
					});
					$('.img_0').addClass('active');
					$('.carousel').carousel(0);

					$('#news_text').html(res.announcement);
					$('.main_wallet').text("₹ " + res.wallet_balance);
					///
					$('.u_name').html(res.name);
					$('.u_outlet').html(res.shop_name);
					$('.u_mobile').html(res.mobile);
					//alert(localStorage.getItem("role_id"));

					localStorage.setItem("u_name", res.name);
					localStorage.setItem("u_shop_name", res.shop_name);
					localStorage.setItem("u_mobile", res.mobile);
					localStorage.setItem("u_email", res.email);
					localStorage.setItem("company_data", JSON.stringify(res.company_data));
					$('#profile_pic').attr("src", res.profile);
					if (res.day_book) {
						$("#rc_success_hit").text(res.day_book.rc_success_hit);
						$("#rc_success_amount").text("₹ " + res.day_book.rc_success_amount);
						$("#rc_pending_hit").text(res.day_book.rc_pending_hit);
						$("#rc_pending_amount").text("₹ " + res.day_book.rc_pending_amount);
						$("#rc_failed_hit").text(res.day_book.rc_failed_hit);
						$("#rc_failed_amount").text("₹ " + res.day_book.rc_failed_amount);
						$("#rc_refund_hit").text(res.day_book.rc_refund_hit);
						$("#rc_refund_amount").text("₹ " + res.day_book.rc_refund_amount);
						$("#rc_turnover_amount").text("₹ " + res.day_book.rc_success_amount);
						$("#rc_commission_amount").text("₹ " + res.day_book.rc_commission);
						//$("#rc_success_amount").text(res.day_book.rc_success_amount);
						$("#rc_receive_amount").text("₹ " + res.day_book.rc_receive_money);
						//$("#rc_complaint_hit").text(0);
						$("#rc_complaint_hit").text(res.day_book.rc_complaint_hit);
					}
					///
					// $('#DialogBasic').modal('show');
					// $("#alert_error").text("Success");
					// $("#alert_error_msg").text(res.message);



				} else {
					window.location.replace('login.html');
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

} else if (PAGE == "PREPAID_PAGE") {
	balanceRefresh();
	$('#loader').hide();

	function selectConatctNumber(){
		navigator.contacts.pickContact(function(contact){
			var text = JSON.stringify(contact['phoneNumbers'][0].value)
			number = text.replace(/"/g, "").replace(/-/g, "").replace(/ /g, "").replace('+91', "");
			$('#recharge_number').val(number);
			checkNumber();
			// $('#DialogBasic').modal('show');
			// $("#alert_error").text("Error");
			// $("#alert_error_msg").text(number);
			//console.log('The following contact has been selected:' + JSON.stringify(contact));
		},function(err){
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text(err);
		});
	}

	function checkNumber() {
		let number = $('#recharge_number').val();
		if (number.length === 10) {
			$.ajax({
				url: BASE_URL + 'check-number',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					number: number
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						changeState(res.state_id, res.state_name);
						changeProvider(res.provider_id, res.provider_name, res.provider_logo)
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}

	}

	function btnClick(type) {
		if (type == "Mobile") {
			$('#homePage').hide();
			$('#prepaidRechargePage').show();
			//alert(type);
		} else if (type == "Select State") {
			$('#rechargeInput').hide();
			var states = JSON.parse(localStorage.getItem("states"));
			$('#stateData').empty();
			$.each(states, function (j, v) {
				html = '';
				html += '<div class="col-3" onclick="changeState(`' + states[j].id + '`,`' + states[j].state_name + '`)">' +
					'<div class="s_div">' +
					'<img src="assets/img/ui_icons/flag.png" class="s_icon">' +
					'</div>' +
					'<p class="text-center font_shiba">' + states[j].state_name + '</p>' +
					'</div>';
				$('#stateData').append(html);
			});
			$('#selectState').show();

		} else if (type == "Select Provider Mobile") {
			$('#rechargeInput').hide();
			var result = JSON.parse(localStorage.getItem("mobile_provider"));
			$('#providerData').empty();
			$.each(result, function (j, v) {
				html = '';
				html += '<div class="col-3" onclick="changeProvider(`' + result[j].id + '`,`' + result[j].provider_name + '`,`' + result[j].provider_logo + '`)">' +
					'<div class="s_div">' +
					'<img src="' + ADMIN_URL + '/provider_logo/' + result[j].provider_logo + '" class="s_icon">' +
					'</div>' +
					'<p class="text-center font_shiba">' + result[j].provider_name + '</p>' +
					'</div>';
				$('#providerData').append(html);
			});
			$('#selectProvider').show();
		} else {
			return 2;
		}
	}

	function changeState(id, name) {
		$('#rechargeInput').show();
		$('#selectState').hide();
		$('#state_id').val(id);
		$('#state_name').val(name);
	}

	function changeProvider(id, name, logo) {
		$('#rechargeInput').show();
		$('#selectProvider').hide();
		$('#provider_id').val(id);
		$('#provider_name').val(name);
		$('#provider_name').val(name);
		$('#provider_logo').attr('src', ADMIN_URL + '/provider_logo/' + logo);
	}

	function viewRoffer() {
		let provider_id = $('#provider_id').val();
		let number = $('#recharge_number').val();
		if (number == "" || number == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (number.length != 10) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter vaild mobile number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'check-roffer',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					provider_id: provider_id,
					number: number
				}),
				success: function (res) {
					$('#loader').hide();
					$('#rofferDiv').empty();
					if (res.type == 'success') {
						html = '';
						$.each(res.data, function (j, v) {
							html = '';
							// html += '<li class="list-group-item d-flex justify-content-between align-items-center" onclick="changeAmount(' + res.data[j].Price + ')">' + res.data[j].Description +
							// 	'<span class="roffer-amount">' + res.data[j].Price + '</span>' +
							// 	'</li>';
							html = '<div style="border-radius: 10px;background: var(--bs-white);padding: 5px;border: 1px solid var(--bs-purple);margin-bottom: 5px;">'+
									'<div class="row" style="height: max-content;">'+
										'<div class="col-8" style="align-content: center;"><span style="color: hwb(39 9% 18%);padding-left: 5px;font-size: 12px;font-weight: 500;">Description:</span>'+
											'<p style="padding-left: 5px;font-size: 12px;font-weight: 500;">' + res.data[j].Description + '</p>'+
										'</div>'+
										'<div class="col-4" style="padding-top: 5px;"><button type="button" class="btn btn-outline-info" onclick="changeAmount(`' + res.data[j].Price + '`)">₹ ' + res.data[j].Price + '</button></div>'+
									'</div>'+
								'</div>';
							$('#rofferDiv').append(html);
						});

						$('#rechargeInput').hide();
						$('#rofferDiv').show();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function viewPlans() {
		let provider_id = $('#provider_id').val();
		let state_id = $('#state_id').val();
		if (state_id == "" || state_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select state");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'check-view-plan',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					provider_id: provider_id,
					state_id: state_id
				}),
				success: function (res) {
					$('#loader').hide();
					$('#pills-tab').empty();
					$('#pills-tabContent').empty();
					if (res.type == 'success') {
						html = '';
						html2 = '';
						html3 = '';
						tab_list = [];
						$.each(res.data, function (j, v) {
							var cl = j.replace(/[^A-Z]+/g, "");
							tab_list.push(cl);
							html = '<li class="nav-item" role="presentation">'+
								'<button class="nav-link text-primary fw-semibold position-relative" id="pills-' + cl + '-tab" data-bs-toggle="pill" data-bs-target="#pills-' + cl + '" type="button" role="tab" aria-controls="pills-' + cl + '" aria-selected="false" style="width: max-content;">' + j + '</button>'+
              				'</li>';
							html3 = '<div class="tab-pane pills-' + cl + '-tab_add" id="pills-' + cl + '" role="tabpanel" aria-labelledby="pills-' + cl + '-tab"></div>';
							$('#pills-tabContent').append(html3);
							$('#pills-tab').append(html);
							$.each(res.data[j], function (i, item) {
								html2 = '<div style="border-radius: 10px;background: var(--bs-white);padding: 5px;border: 1px solid var(--bs-purple);margin-bottom: 5px;">'+
											'<div class="row" style="height: 45px;">'+
												'<div class="col-4" style="align-content: center;">'+
													'<span style="color: hwb(39 9% 18%);padding-left: 5px;font-size: 12px;font-weight: 500;">Talktime :</span>'+
													'<p style="padding-left: 5px;font-size: 12px;font-weight: 500;">₹' + item.talktime + '</p>'+
												'</div>'+
												'<div class="col-4" style="align-content: center;">'+
													'<span style="color: hwb(39 9% 18%);font-size: 12px;font-weight: 500;">Validity :</span>'+
													'<p style="font-size: 12px;font-weight: 500;">' + item.validity + '</p>'+
												'</div>'+
												'<div class="col-4" style="padding-top: 5px;"><button type="button" class="btn btn-outline-info" onclick="changeAmount(' + item.amount + ')">₹ ' + item.amount + '</button></div>'+
											'</div>'+
											'<div class="row">'+
												'<span style="color: hwb(39 9% 18%);font-size: 12px;font-weight: 500;">Description :</span>'+
												'<p style="font-size: 12px;font-weight: 500;">' + item.benefit + '</p>'+
											'</div>'+
										'</div>';
								$('.pills-' + cl + '-tab_add').append(html2);
							});
							$('.pills-' + tab_list[0] + '-tab_add').addClass('active')
							$('#pills-' + tab_list[0] + '-tab').addClass('active')
						});
						
						$('#rechargeInput').hide();
						$('#viewPlanDiv').show();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function filterSelection(c) {
		$(".tab_list").addClass("d-none");
		$("." + c).removeClass("d-none");
		$("." + c).addClass("d-flex");
		$(".tab").removeClass("active");
		$(".tab_" + c).addClass("active");
	}


	function changeAmount(amount) {
		$('#recharge_amount').val(amount);
		$('#rofferDiv').hide();
		$('#viewPlanDiv').hide();
		$('#rechargeInput').show();
	}


	function rechargeNow() {
		let number = $('#recharge_number').val();
		let provider_name = $('#provider_name').val();
		let state_name = $('#state_name').val();
		let amount = $('#recharge_amount').val();

		if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
		} else if (provider_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else if (state_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select state");
		} else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
		} else {
			$('#rechargeInput').hide();
			$('#rechargeConfirmDiv').show();
			$("#cf_number").text(number);
			$("#cf_provider").text(provider_name);
			$("#cf_state").text(state_name);
			$("#cf_amount").text("₹ " + amount);
		}
	}
	function rechargeConfirmNow() {
		let number = $('#recharge_number').val();
		let provider_id = $('#provider_id').val();
		let state_id = $('#state_id').val();
		let amount = $('#recharge_amount').val();
		let pin = $('#recharge_pin').val();
		if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else if (state_id == "" || state_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select state");
		} else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
		} else if (pin == "" || pin == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter pin");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'run-recharge-api',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					number: number,
					provider_id: provider_id,
					service_id: 1,
					state_id: state_id,
					amount: amount,
					pin: pin,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						receiptView(res.id);
						balanceRefresh();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function receiptView(id) {
		$.ajax({
			url: BASE_URL + 'recharge-reciept',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					var company_data = JSON.parse(localStorage.getItem("company_data"));
					$("#td_comapny_domain").text(company_data.domain);
					$("#td_comapny_address").text(company_data.company_address);
					$("#td_comapny_email").text(company_data.support_email);
					$("#td_provider_name").text(res.provider_name);
					$("#td_number").text(res.data.number);
					$("#td_amount").text("₹ " + res.data.amount);
					$("#td_total_amount").text("₹ " + res.data.total_amount);
					$("#td_order_id").text(res.data.order_id);
					$("#td_operator_id").text(res.data.operator_id);
					$("#td_status").text(res.data.status);
					$("#td_date_time").text(res.data.created_at);
					if (res.data.status == "Success") {
						$("#receiptHeader").css("background-color", "var(--bs-green)");
						$("#td_status").addClass("badge badge-success");
						$("#td_commission").text("₹ " + res.data.commission);
					} else if (res.data.status == "Failed") {
						$("#receiptHeader").css("background-color", "var(--bs-danger)");
						$("#td_status").addClass("badge badge-danger");
						$("#td_commission").text("₹ 0");
					} else {
						$("#receiptHeader").css("background-color", "var(--bs-orange)");
						$("#td_status").addClass("badge badge-warning");
						$("#td_commission").text("₹ " + res.data.commission);
					}

					$('#td_user_details').text('Name : ' + res.data.first_name + " " + res.data.middle_name + " " + res.data.last_name + ' | Mobile : ' + res.data.mobile_number + ' | Email : ' + res.data.email_address);
					$('#rechargeConfirmDiv').hide();
					$('#receiptPage').show();
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
} else if (PAGE == "BBPS_PAGE") {
	balanceRefresh();
	$('#loader').hide();
	selectProvider();
	//$('#selectProvider').show();

	$("#search_provider").on("keyup", function() {
		var value = $(this).val().toLowerCase();
		$(".p_name").filter(function() {
			let item = $(this).text().toLowerCase().indexOf(value) > -1;
			$('#p_div_'+$(this).attr('id')).toggle(item);
		});
	});
	function selectProvider() {
		$('#rechargeInput').hide();
		let searchParams = new URLSearchParams(window.location.search);
		let service_id = searchParams.get('service_id');
		if(localStorage.getItem(service_id+"_provider")){
			var data = JSON.parse(localStorage.getItem(service_id+"_provider"));
			$('#services').text(data.service);
			result = data.providers;
			$('#providerData').empty();
			$.each(result, function (j, v) {
				html = '';
				html += '<div id="p_div_' + result[j].id +'"><div class="col-12"  onclick="changeProvider(`' + result[j].id + '`,`' + result[j].provider_name + '`,`' + result[j].provider_logo + '`)" style="display: flex;">' +
					'<div class="col-2"><div class="s_div">' +
					'<img src="' + ADMIN_URL + '/provider_logo/' + result[j].provider_logo + '" class="s_icon">' +
					'</div></div>' +
					'<div class="col-10"><p id="' + result[j].id +'" class="p_name" class="text-center font_shiba">' + result[j].provider_name + '</p></div>' +
					'</div><hr class="mt-1"></div>';
				$('#providerData').append(html);
			});
			$('#selectProvider').show();
		}else{
			$.ajax({
				url: BASE_URL + 'fetch-provider',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					service_id
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#services').text(res.data.service);
						//console.log(res);
						result = res.data.providers;
						localStorage.setItem(service_id+"_provider", JSON.stringify(res.data));
						$('#providerData').empty();
						$.each(result, function (j, v) {
							html = '';
							html += '<div id="p_div_' + result[j].id +'"><div class="col-12" onclick="changeProvider(`' + result[j].id + '`,`' + result[j].provider_name + '`,`' + result[j].provider_logo + '`)" style="display: flex;">' +
								'<div class="col-2"><div class="s_div">' +
								'<img src="' + ADMIN_URL + '/provider_logo/' + result[j].provider_logo + '" class="s_icon">' +
								'</div></div>' +
								'<div class="col-10"><p id="' + result[j].id +'" class="p_name" class="text-center font_shiba">' + result[j].provider_name + '</p></div>' +
								'</div><hr class="mt-1"></div>';
							$('#providerData').append(html);
						});
						$('#selectProvider').show();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
		
	}

	function changeProvider(id, name, logo) {
		$('#rechargeInput').show();
		$('#selectProvider').hide();
		$('#provider_id').val(id);
		$('#provider_name').val(name);
		$('#provider_name').val(name);
		$('#provider_logo').attr('src', ADMIN_URL + '/provider_logo/' + logo);
		$('#loader').show();
		$("#params_div").empty();
        $('#bill_fatch').hide();
		$.ajax({
			url: BASE_URL + 'bbps/fetch-params-provider',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id : $('#provider_id').val()
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					params = JSON.parse(res.biller.biller_data);
					var param = {}; // my object
                    var params_data = []; // my array
                    param = { param: params.data.label_1, regex: params.data.regex_1, option: params.data.regex_1_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_2, regex: params.data.regex_2, option: params.data.regex_2_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_3, regex: params.data.regex_3, option: params.data.regex_3_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_4, regex: params.data.regex_4, option: params.data.regex_4_autocomplete_values }
                    params_data.push(param);
                    param = { param: params.data.label_5, regex: params.data.regex_5, option: params.data.regex_5_autocomplete_values }
                    params_data.push(param);
                    console.log(params_data);
					html = '';
					count = parseInt(params.input_count);
                    for (i = 0; i < parseInt(count); ++i) {
                        if (params_data[i].regex) {
                            regex = '<input type="text" class="rc-input font_shiba" name="' + "filed_" + i + '" value="" id="' + "filed_" + i + '"  pattern="' + params_data[i].regex + '" required placeholder="' + params_data[i].param + '">';
                        } else {
                            options = '';
                            for (i2 = 0; i2 < params_data[i].option.length; ++i2) {
                                options += '<option value="' + params_data[i].option[i2].value + '">' + params_data[i].option[i2].display_name + '</option>';
                            }
                            regex = '<select class="rc-input font_shiba" data-choices name="' + "filed_" + i + '" id="' + "filed_" + i + '">' +
                                '<option value="">Select ' + params_data[i].param + '</option>' +
                                options +
                                '</select>';
                        }
                        html += '<div class="row row-input mt-2">' +
                            '<div class="col-12">' +
                            regex +
                            '</div>' +
                            '</div>';
                        //    $("#params_div").append(html); 
						console.log(html);
                    }
					if(res.provider.bill_fetch == "1"){
						$('#bill_amount').hide();
						$('#bill_pay').hide();
						$('#bill_fatch').show();
					}else{
						$('#bill_amount').show();
						$('#bill_pay').show();
						$('#bill_fatch').hide();
					}
					$("#params_div").append(html);
					$('#bill_details_div').hide();
                    // $('#bill_amount').hide();
                    // $('#bill_pay').hide();
					// $('#bill_fatch').show();
					//console.log(params)
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

	function paramToJson(params) {
		return JSON.parse('{"' + decodeURI(params).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g,'":"') + '"}');
	}

	
	function billFatch() {
		var login_key = localStorage.getItem("login_key");
		var user_id = localStorage.getItem("id");
        var provider_id = $("#provider_id").val();
        var param_data = $('#params_div').serialize() + '&provider_id=' + provider_id+'&login_key=' + login_key + '&user_id=' + user_id;
		$('#loader').show();
		$.ajax({
			url: BASE_URL + 'bbps/fetch-bill-details',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify(paramToJson(param_data)),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					if (res.type == "success") {
						$("#pay_amount").val(res.data.minBillAmount);
						$("#billAmount").val(res.data.billAmount);
						$("#billnetamount").val(res.data.billnetamount);
						$("#billdate").val(res.data.billdate);
						$("#dueDate").val(res.data.dueDate);
						$("#minBillAmount").val(res.data.minBillAmount);
						$("#acceptPayment").val(res.data.acceptPayment);
						$("#acceptPartPay").val(res.data.acceptPartPay);
						$("#userName").val(res.data.userName);
						$('#bill_fatch').hide();
						$('#bill_details_div').show();
						$('#bill_amount').show();
						$('#bill_pay').show();
						$('#filed_0').attr('readonly', true);
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
    }

	function billPaymentNow() {
        amount = $("#pay_amount").val();
        number = $("#filed_0").val();
        service_id = $("#service_id").val();
        provider_id = $("#provider_id").val();
        if (number == "") {
            $('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
        } else if (provider_id == "") {
            $('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
        } else if (amount == "") {
            $('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
        } else {
            $("#cf_number").text(number);
            $("#cf_provider").text($('#provider_name').val());
            $("#cf_amount").text(amount);
			$('#rechargeConfirmDiv').show();
			$('#rechargeInput').hide();
        }
    }


	function billPaymentConfirm() {
		let searchParams = new URLSearchParams(window.location.search);
		let service_id = searchParams.get('service_id');
        var number = $("#filed_0").val();
        var provider_id = $("#provider_id").val();
        var optional_1 = $("#filed_1").val();
        var optional_2 = $("#filed_2").val();
        var optional_3 = $("#filed_3").val();
        var optional_4 = $("#filed_4").val();
        var optional_5 = $("#filed_5").val();
        var amount = $("#pay_amount").val();
        var pin = $("#t_pin").val();
		if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
			$("#alert_error_msg").text("select state");
		} else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
		} else if (pin == "" || pin == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter pin");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'run-recharge-api',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					number,
					provider_id,
					service_id,
					optional_1,optional_2,optional_3,optional_4,optional_5,
					amount,
					pin,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						receiptView(res.id);
						balanceRefresh();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}


	function receiptView(id) {
		$.ajax({
			url: BASE_URL + 'recharge-reciept',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					var company_data = JSON.parse(localStorage.getItem("company_data"));
					$("#td_comapny_domain").text(company_data.domain);
					$("#td_comapny_address").text(company_data.company_address);
					$("#td_comapny_email").text(company_data.support_email);
					$("#td_provider_name").text(res.provider_name);
					$("#td_number").text(res.data.number);
					$("#td_amount").text("₹ " + res.data.amount);
					$("#td_total_amount").text("₹ " + res.data.total_amount);
					$("#td_order_id").text(res.data.order_id);
					$("#td_operator_id").text(res.data.operator_id);
					$("#td_status").text(res.data.status);
					$("#td_date_time").text(res.data.created_at);
					if (res.data.status == "Success") {
						$("#receiptHeader").css("background-color", "var(--bs-green)");
						$("#td_status").addClass("badge badge-success");
						$("#td_commission").text("₹ " + res.data.commission);
					} else if (res.data.status == "Failed") {
						$("#receiptHeader").css("background-color", "var(--bs-danger)");
						$("#td_status").addClass("badge badge-danger");
						$("#td_commission").text("₹ 0");
					} else {
						$("#receiptHeader").css("background-color", "var(--bs-orange)");
						$("#td_status").addClass("badge badge-warning");
						$("#td_commission").text("₹ " + res.data.commission);
					}

					$('#td_user_details').text('Name : ' + localStorage.getItem("u_name") + ' | Mobile : ' + localStorage.getItem("u_mobile") + ' | Email : ' + localStorage.getItem("u_email"));
					$('#rechargeConfirmDiv').hide();
					$('#receiptPage').show();
					$('#dthInfoDiv').hide();
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
	
} else if (PAGE == "DTH_PAGE") {


	
	balanceRefresh();
	$('#loader').hide();
	selectProvider();
	function selectProvider() {
		$('#rechargeInput').hide();
		var result = JSON.parse(localStorage.getItem("dth_provider"));
		$('#providerData').empty();
		$.each(result, function (j, v) {
			html = '';
			html += '<div class="col-3" onclick="changeProvider(`' + result[j].id + '`,`' + result[j].provider_name + '`,`' + result[j].provider_logo + '`)">' +
				'<div class="s_div">' +
				'<img src="' + ADMIN_URL + '/provider_logo/' + result[j].provider_logo + '" class="s_icon">' +
				'</div>' +
				'<p class="text-center font_shiba">' + result[j].provider_name + '</p>' +
				'</div>';
			$('#providerData').append(html);
		});
		$('#selectProvider').show();
	}

	function changeProvider(id, name, logo) {
		$('#rechargeInput').show();
		$('#selectProvider').hide();
		$('#provider_id').val(id);
		$('#provider_name').val(name);
		$('#provider_name').val(name);
		$('#provider_logo').attr('src', ADMIN_URL + '/provider_logo/' + logo);
	}

	function rechargeNow() {
		let number = $('#recharge_number').val();
		let provider_name = $('#provider_name').val();
		let amount = $('#recharge_amount').val();

		if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
		} else if (provider_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
		} else {
			$('#dthInfoDiv').hide();
			$('#rechargeInput').hide();
			$('#rechargeConfirmDiv').show();
			$("#cf_number").text(number);
			$("#cf_provider").text(provider_name);
			$("#cf_amount").text("₹ " + amount);
		}
	}

	function rechargeConfirmNow() {
		let number = $('#recharge_number').val();
		let provider_id = $('#provider_id').val();
		let amount = $('#recharge_amount').val();
		let pin = $('#recharge_pin').val();
		if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
			$("#alert_error_msg").text("select state");
		} else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter amount");
		} else if (pin == "" || pin == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter pin");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'run-recharge-api',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					number: number,
					provider_id: provider_id,
					service_id: 4,
					amount: amount,
					pin: pin,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						receiptView(res.id);
						balanceRefresh();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function dthInfo() {
		let provider_id = $('#provider_id').val();
		let number = $('#recharge_number').val();
		if (number == "" || number == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter vaild mobile number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'dth-info',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					provider_id: provider_id,
					number: number
				}),
				success: function (res) {
					var data = JSON.parse(res);
					console.log(data);
					$('#loader').hide();
					$('#dthInfoData').empty();
					if (data.status == 'Success') {
						console.log(data.data);
						if (data.data) {
							//dth = res.data[0];
							$.each(data.data, function (j, v) {
								console.log(j);
								console.log(v);
								html2 = '<li class="list-group-item d-flex justify-content-between align-items-center">' + j +
									'<span class="roffer-amount">' + v + '</span>' +
									'</li>';
								$('#dthInfoData').append(html2);
							});
							$('#dthInfoDiv').show();
							//alert(dth.status);
						} else {
							$('#DialogBasic').modal('show');
							$("#alert_error").text("Error");
							$("#alert_error_msg").text("Server Error");
						}
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function dthPlans() {
		let provider_id = $('#provider_id').val();
		if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'dth-plans',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					provider_id: provider_id
				}),
				success: function (res) {
					$('#loader').hide();
					$('#dthPlanDataTabs').empty();
					$('#dthPlanData').empty();
					if (res.type == 'success') {
						html = '';
						html2 = '';
						
						$.each(res.data, function (j, v) {
							var cl = j.replace(/[^A-Z]+/g, "");
							html = '<li class="nav-item tab_' + cl + '" onclick="filterSelection(`' + cl + '`)"><a class="nav-link tab tab_' + cl + '">' + j + '</a></li>';
							$('#dthPlanDataTabs').append(html);
							$.each(res.data[j], function (i, item) {
								price = '';
								$.each(item.prices, function (i2, item2) {
									if(item.description ==="null" ||item.description ===""){
										description = "";
									}else{
										description = item.description;
									}
									price += '<div class="col-3 plans-price">'+
												'<h5 style="text-align: center;">' + item2.Validity + '</h5>'+
											'<span class="roffer-amount" style="text-align: center;" onclick="changeAmount(' + item2.amount+ ')">₹' + item2.amount + '</span>'+
										'</div>';
								});
								html2 = '<li class="list-group-item tab_list ' + cl + ' mb-1" id="plan_div_' + item.id+ '" style="border-radius: 10px;border: 2px solid var(--bs-orange);"><div class="row">'+
										'<div class="col-12"><h5 style="text-align: center;" class="plan_name" id="' + item.id+ '">' + item.plan_name + ' - ' + j + '</h5</div>'+
										'<div class="col-12">' + item.pictureQuality + ' - ' + item.languages + '</div>'+
										'<div class="col-12">' + description + '</div>'+
										'<div class="row mt-1">'+
										price+
									'</div></div>'+
								'</li>';
								$('#dthPlanData').append(html2);
							});

						});
						$('#rechargeInput').hide();
						$('#dthPlanDiv').show();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}


	$("#search_plan_name").on("keyup", function() {
		var value = $(this).val().toLowerCase();
		///console.log(value);
		$(".plan_name").filter(function() {
			let item = $(this).text().toLowerCase().indexOf(value) > -1;
			//console.log(this);
			$('#plan_div_'+$(this).attr('id')).toggle(item);
		});
	});

	function filterSelection(c) {
		$(".tab_list").addClass("d-none");
		$("." + c).removeClass("d-none");
		//$("." + c).addClass("d-flex");
		$(".tab").removeClass("active");
		$(".tab_" + c).addClass("active");
	}


	function changeAmount(amount) {
		$('#recharge_amount').val(amount);
		//$('#rofferDiv').hide();
		$('#dthPlanDiv').hide();
		$('#rechargeInput').show();
	}

	function dthRefresh() {
		let provider_id = $('#provider_id').val();
		let number = $('#recharge_number').val();
		if (number == "" || number == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter vaild mobile number");
		} else if (provider_id == "" || provider_id == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("select provider");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'dth-heavy-refresh',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					provider_id: provider_id,
					number: number
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						if (res.data.status == "Success") {
							$('#DialogBasic').modal('show');
							$("#alert_error").text("Success");
							$("#alert_error_msg").text();
							$("#alert_error_msg").html('<p>'+res.data.message+'</p><h5>'+res.data.data.Customer_Name+'</h5>');
						} else {
							$('#DialogBasic').modal('show');
							$("#alert_error").text("Error");
							$("#alert_error_msg").text(res.data.desc);
							
						}
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

	function receiptView(id) {
		$.ajax({
			url: BASE_URL + 'recharge-reciept',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					var company_data = JSON.parse(localStorage.getItem("company_data"));
					$("#td_comapny_domain").text(company_data.domain);
					$("#td_comapny_address").text(company_data.company_address);
					$("#td_comapny_email").text(company_data.support_email);
					$("#td_provider_name").text(res.provider_name);
					$("#td_number").text(res.data.number);
					$("#td_amount").text("₹ " + res.data.amount);
					$("#td_total_amount").text("₹ " + res.data.total_amount);
					$("#td_order_id").text(res.data.order_id);
					$("#td_operator_id").text(res.data.operator_id);
					$("#td_status").text(res.data.status);
					$("#td_date_time").text(res.data.created_at);
					if (res.data.status == "Success") {
						$("#receiptHeader").css("background-color", "var(--bs-green)");
						$("#td_status").addClass("badge badge-success");
						$("#td_commission").text("₹ " + res.data.commission);
					} else if (res.data.status == "Failed") {
						$("#receiptHeader").css("background-color", "var(--bs-danger)");
						$("#td_status").addClass("badge badge-danger");
						$("#td_commission").text("₹ 0");
					} else {
						$("#receiptHeader").css("background-color", "var(--bs-orange)");
						$("#td_status").addClass("badge badge-warning");
						$("#td_commission").text("₹ " + res.data.commission);
					}

					$('#td_user_details').text('Name : ' + localStorage.getItem("u_name") + ' | Mobile : ' + localStorage.getItem("u_mobile") + ' | Email : ' + localStorage.getItem("u_email"));
					$('#rechargeConfirmDiv').hide();
					$('#receiptPage').show();
					$('#dthInfoDiv').hide();
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}


} else if (PAGE == "INSTANT_ADD_MONEY") {
	balanceRefresh();
	$("#loader").hide();

	function makePaymentNow() {
		let amount = $('#recharge_amount').val();
		let type = $('#add_money_type').val();
		if(type == "" || type == 0){
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("Please Select Method");
		}else if (amount == "" || amount == 0) {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("Enter Valid Amount");
		} else {
			if(type == "qr"){
				payViaQr(amount);
			}else{
				payViaUpi(amount);
			}
		}
	}

	function changeModeType(mode){
		$('#add_money_type').val(mode);
		if(mode == "qr"){
			$(".qr_mode").css('background-color', '#0a9149');
			$(".qr_mode").css('border-color', '#671ae5');
			$(".upi_mode").css('background-color', '#626d78');
			$(".upi_mode").css('border-color', '#106cf3');
		}else if(mode == "upi"){	
			$(".upi_mode").css('background-color', '#0a9149');
			$(".upi_mode").css('border-color', '#671ae5');
			$(".qr_mode").css('background-color', '#626d78');
			$(".qr_mode").css('border-color', '#106cf3');
		}
	}


	function payViaUpi(amount){
		$("#loader").show();
			$.ajax({
				url: BASE_URL + 'instant-add-money',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					amount: amount
				}),
				success: function (res) {
					$('#loader').hide();
					//alert(PAY_URL +"users/login");
					if (res.type == 'success') {
						$('#recharge_amount').val("");
						var inAppBrowserRef;
						function openInAppBrowser() {
							inAppBrowserRef = cordova.InAppBrowser.open(res.pay_url, '_self', "location=no,zoom=no,toolbarcolor=#00ff00");
							inAppBrowserRef.addEventListener('loadstart', loadStartCallBack);
						}
						function loadStartCallBack(event) {
							if (event.url === PAY_URL + "users/login" || event.url === PAY_URL + "users/login/") {
								inAppBrowserRef.close();
								balanceRefresh();
							}
						}
						openInAppBrowser();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
	}

	function payViaQr(amount){
		$("#loader").show();
			$.ajax({
				url: BASE_URL + 'instant-add-money-qr-code',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					amount: amount
				}),
				success: function (res) {
					$('#loader').hide();
					//alert(PAY_URL +"users/login");
					if (res.type == 'success') {
						$('#recharge_amount').val("");
						var inAppBrowserRef;
						function openInAppBrowser() {
							inAppBrowserRef = cordova.InAppBrowser.open(res.pay_url, '_self', "location=no,zoom=no,toolbarcolor=#00ff00");
							inAppBrowserRef.addEventListener('loadstart', loadStartCallBack);
						}
						function loadStartCallBack(event) {
							if (event.url === PAY_URL + "users/login" || event.url === PAY_URL + "users/login/") {
								inAppBrowserRef.close();
								balanceRefresh();
							}
						}
						openInAppBrowser();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
	}

	function changeAmount(amount) {
		$('#recharge_amount').val(amount);
	}
} else if (PAGE == "RECHARGE_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));



	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		let number = $("#number").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'recharge-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				number,
				order_id: "",
				request_order_id: "",
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {

							if (item.status == "Success") {
								s_bg = "success";
							} else if (item.status == "Failed" || item.status == "Refunded") {
								s_bg = "danger";
							} else {
								s_bg = "warning";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: red;">- ₹ ' + item.amount + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + item.status + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.closing_balance + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row">' +
								'<div class="col-2 text-left mt-1" style="padding-left: 24px !important;">' +
								'<img src="' + ADMIN_URL + "provider_logo/" + item.provider_logo + '" style="width: 45px;height: 45px;">' +
								'</div>' +
								'<div class="col-6" style="padding-top: 5px;">' +
								'<div class="row"><a style="font-size: 18px;font-weight: 500;">' + item.provider_name + '</a></div>' +
								'<div class="row"><a>' + item.number + '</a></div>' +
								'</div>' +
								'<div class="col-4 text-left" style="padding-top: 10px;">' +
								'<a style="font-size: 24px;font-weight: 500;color: #1e74fd;">₹ ' + item.total_amount + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Order Id : </a><a >' + item.order_id + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Operator Id : </a><a >' + item.operator_id + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet Name : </a><a >' + item.outlet_name + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet No : </a><a >' + item.mobile_number + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Opening Balance : </a><a >₹ ' + item.opening_balance + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Commission : </a><a >₹ ' + item.commission + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Path : </a><a >' + item.path + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row text-center p-1">' +
								'<div class="col-4" onclick="sendCompalint(`' + item.id + '`)">' +
								'<a href="javascript:void(0)" class="btn btn-primary">Complaint</a>' +
								'</div>' +
								'<div class="col-6 p-1">' +
								'<span>' + item.created_at + '</span>' +
								'</div>' +
								'<div class="col-2 text-right" onclick="receiptView(`' + item.id + '`)">' +
								'<img src="assets/img/ui_icons/share.png" style="width: 45px;height: 45px;">' +
								'</div>' +
								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}


	function receiptView(id) {
		$('#loader').show();
		$.ajax({
			url: BASE_URL + 'recharge-reciept',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					var company_data = JSON.parse(localStorage.getItem("company_data"));
					$("#td_comapny_domain").text(company_data.domain);
					$("#td_comapny_address").text(company_data.company_address);
					$("#td_comapny_email").text(company_data.support_email);
					$("#td_provider_name").text(res.provider_name);
					$("#td_number").text(res.data.number);
					$("#td_amount").text("₹ " + res.data.amount);
					$("#td_total_amount").text("₹ " + res.data.total_amount);
					$("#td_order_id").text(res.data.order_id);
					$("#td_operator_id").text(res.data.operator_id);
					$("#td_status").text(res.data.status);
					$("#td_date_time").text(res.data.created_at);
					if (res.data.status == "Success") {
						$("#receiptHeader").css("background-color", "var(--bs-green)");
						$("#td_status").addClass("badge badge-success");
						$("#td_commission").text("₹ " + res.data.commission);
					} else if (res.data.status == "Failed") {
						$("#receiptHeader").css("background-color", "var(--bs-danger)");
						$("#td_status").addClass("badge badge-danger");
						$("#td_commission").text("₹ 0");
					} else {
						$("#receiptHeader").css("background-color", "var(--bs-orange)");
						$("#td_status").addClass("badge badge-warning");
						$("#td_commission").text("₹ " + res.data.commission);
					}

					$('#td_user_details').text('Name : ' + res.data.first_name + " " + res.data.middle_name + " " + res.data.last_name + ' | Mobile : ' + res.data.mobile_number + ' | Email : ' + res.data.email_address);
					$('.extraHeader').hide();
					$('#results2').hide();
					$('#receiptPage').show();
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

	function backRecharge() {
		$('#receiptPage').hide();
		// $('#appCapsule').removeClass("mt-6");
		// $('#dateDiv').addClass("mt-6");
		$('#results2').show();
		$('.extraHeader').show();
		//$('#dateDiv').show();
	}

	function sendCompalint(id) {
		$("#loader").show();
		$.ajax({
			url: BASE_URL + 'send-complaint',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
				subject: "Recharge Problem",
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Success");
					$("#alert_error_msg").text(res.message);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

} else if (PAGE == "ACCOUNT_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));

	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		let order_id = $("#order_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'account-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				number: "",
				order_id,
				request_order_id: "",
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {
							if (item.fund_type == "Credit") {
								s_bg = "success";
								a_bg = "green";
								a_inr = "+";
							} else {
								s_bg = "danger";
								a_bg = "red";
								a_inr = "-";
							}



							if (item.d_id == 0) {
								d_act_by = "";
							} else {
								d_act_by = item.d_outlet_name + " - " + item.d_mobile_number + "(" + item.d_id + ")";
							}

							if (item.c_id == 0) {
								c_act_by = "";
							} else {
								c_act_by = item.c_outlet_name + " - " + item.c_mobile_number + "(" + item.c_id + ")";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: ' + a_bg + ';">' + a_inr + ' ₹ ' + item.amount + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + item.fund_type + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.closing_balance + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Date & Time : </a><a >' + item.transaction_date + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Order Id : </a><a >' + item.order_id + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Type : </a><a >' + item.transaction_type + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Total Amount : </a><a >₹ ' + item.total_amount + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet Name : </a><a >' + item.u_outlet_name + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet No : </a><a >' + item.u_mobile_number + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Credit By : </a><a >' + c_act_by + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Debit By : </a><a >' + d_act_by + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Opening Balance : </a><a >₹ ' + item.opening_balance + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Remark : </a><a > ' + item.remark + '</a>' +
								'</div>' +

								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

} else if (PAGE == "FUND_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));

	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		let order_id = $("#order_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'fund-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				number: "",
				order_id,
				request_order_id: "",
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {
							if (item.fund_type == "Credit") {
								s_bg = "success";
								a_bg = "green";
								a_inr = "+";
							} else {
								s_bg = "danger";
								a_bg = "red";
								a_inr = "-";
							}



							if (item.d_id == 0) {
								d_act_by = "";
							} else {
								d_act_by = item.d_outlet_name + " - " + item.d_mobile_number + "(" + item.d_id + ")";
							}

							if (item.c_id == 0) {
								c_act_by = "";
							} else {
								c_act_by = item.c_outlet_name + " - " + item.c_mobile_number + "(" + item.c_id + ")";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: ' + a_bg + ';">' + a_inr + ' ₹ ' + item.amount + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + item.fund_type + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.closing_balance + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Date & Time : </a><a >' + item.transaction_date + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Order Id : </a><a >' + item.order_id + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Type : </a><a >' + item.transaction_type + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Total Amount : </a><a >₹ ' + item.total_amount + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet Name : </a><a >' + item.u_outlet_name + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Outlet No : </a><a >' + item.u_mobile_number + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Credit By : </a><a >' + c_act_by + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Debit By : </a><a >' + d_act_by + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Opening Balance : </a><a >₹ ' + item.opening_balance + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Remark : </a><a > ' + item.remark + '</a>' +
								'</div>' +

								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

} else if (PAGE == "FUND_REQUEST_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));

	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		let order_id = $("#order_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'fund-request-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				number: "",
				order_id,
				request_order_id: "",
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {
							if (item.status == "Transferred") {
								s_bg = "success";
							} else if (item.status == "Rejected") {
								s_bg = "danger";
							} else {
								s_bg = "warning";
							}



							if (item.d_id == 0) {
								d_act_by = "";
							} else {
								d_act_by = item.d_outlet_name + " - " + item.d_mobile_number + "(" + item.d_id + ")";
							}

							if (item.d_id == 0) {
								c_act_by = "";
							} else {
								c_act_by = item.d_outlet_name + " - " + item.d_mobile_number + "(" + item.d_id + ")";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.amount + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + item.status + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">' + item.transfer_mode + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Date & Time : </a><a >' + item.request_date + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Order Id : </a><a >' + item.order_id + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Name : </a><a >' + item.account_name + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">A/c No. : </a><a >' + item.account_number + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">A/c Type : </a><a >' + item.account_type + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Bank : </a><a >' + item.bank_name + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action By : </a><a >' + d_act_by + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action Date : </a><a >' + item.decision_date + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action Remark : </a><a >' + item.decision_remark + '</a>' +
								'</div>' +

								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Txn/Ref : </a><a >' + item.transaction_number + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Remark : </a><a > ' + item.remark + '</a>' +
								'</div>' +

								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
} else if (PAGE == "COMPLAINT_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));

	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		let request_id = $("#request_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'complaint-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				request_id,
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {
							if (item.status == "Sloved") {
								s_bg = "success";
							} else if (item.status == "Closed") {
								s_bg = "danger";
							} else {
								s_bg = "warning";
							}



							if (item.d_id == 0) {
								d_act_by = "";
							} else {
								d_act_by = item.d_outlet_name + " - " + item.d_mobile_number + "(" + item.d_id + ")";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">' + item.service_name + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + item.status + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-primary" onclick="receiptView(' + item.report_id + ')">Reciept View</span>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Date & Time : </a><a >' + item.created_at + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Request Id : </a><a >' + item.request_id + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action By : </a><a >' + d_act_by + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action Date : </a><a >' + item.decision_date + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Action Remark : </a><a >' + item.decision_remark + '</a>' +
								'</div>' +
								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

	function receiptView(id) {
		$('#loader').show();
		$.ajax({
			url: BASE_URL + 'recharge-reciept',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				id: id,
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					var company_data = JSON.parse(localStorage.getItem("company_data"));
					$("#td_comapny_domain").text(company_data.domain);
					$("#td_comapny_address").text(company_data.company_address);
					$("#td_comapny_email").text(company_data.support_email);
					$("#td_provider_name").text(res.provider_name);
					$("#td_number").text(res.data.number);
					$("#td_amount").text("₹ " + res.data.amount);
					$("#td_total_amount").text("₹ " + res.data.total_amount);
					$("#td_order_id").text(res.data.order_id);
					$("#td_operator_id").text(res.data.operator_id);
					$("#td_status").text(res.data.status);
					$("#td_date_time").text(res.data.created_at);
					if (res.data.status == "Success") {
						$("#receiptHeader").css("background-color", "var(--bs-green)");
						$("#td_status").addClass("badge badge-success");
						$("#td_commission").text("₹ " + res.data.commission);
					} else if (res.data.status == "Failed") {
						$("#receiptHeader").css("background-color", "var(--bs-danger)");
						$("#td_status").addClass("badge badge-danger");
						$("#td_commission").text("₹ 0");
					} else {
						$("#receiptHeader").css("background-color", "var(--bs-orange)");
						$("#td_status").addClass("badge badge-warning");
						$("#td_commission").text("₹ " + res.data.commission);
					}

					$('#td_user_details').text('Name : ' + res.data.first_name + " " + res.data.middle_name + " " + res.data.last_name + ' | Mobile : ' + res.data.mobile_number + ' | Email : ' + res.data.email_address);
					$('.extraHeader').hide();
					$('#results2').hide();
					$('#receiptPage').show();
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}

	function backRecharge() {
		$('#receiptPage').hide();
		$('#results2').show();
		$('.extraHeader').show();
	}

} else if (PAGE == "DAYBOOK_REPORTS") {
	$("#date_from").val(dateFormat(new Date(), 1));
	$("#date_to").val(dateFormat(new Date(), 1));

	fetchAllData();
	function fetchAllData() {
		let from_date = $("#date_from").val();
		let to_date = $("#date_to").val();
		//let order_id = $("#order_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'daybook-reports',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				from_date,
				to_date
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					$("#rc_success_hit").text(res.data.rc_success_hit);
					$("#rc_success_amount").text("₹ " + res.data.rc_success_amount);
					$("#rc_pending_hit").text(res.data.rc_pending_hit);
					$("#rc_pending_amount").text("₹ " + res.data.rc_pending_amount);
					$("#rc_failed_hit").text(res.data.rc_failed_hit);
					$("#rc_failed_amount").text("₹ " + res.data.rc_failed_amount);
					$("#rc_refund_hit").text(res.data.rc_refund_hit);
					$("#rc_refund_amount").text("₹ " + res.data.rc_refund_amount);
					$("#rc_turnover_amount").text("₹ " + res.data.rc_success_amount);
					$("#rc_commission_amount").text("₹ " + res.data.rc_commission);
					$("#rc_receive_amount").text("₹ " + res.data.rc_receive_money);
					$("#rc_complaint_hit").text(res.data.rc_complaint_hit);
					$('#rc_wallet_balance').text("₹ " + res.data.wallet_balance);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
} else if (PAGE == "MY_PROFILE") {
	$('#loader').show();
	$.ajax({
		url: BASE_URL + 'my-profile',
		type: 'POST',
		contentType: 'application/json',
		data: JSON.stringify({
			login_key: localStorage.getItem("login_key"),
			user_id: localStorage.getItem("id")
		}),
		success: function (res) {
			$('#loader').hide();
			if (res.type == 'success') {
				$("#first_name").val(res.data.first_name);
				$("#middle_name").val(res.data.middle_name);
				$("#last_name").val(res.data.last_name);
				$("#mobile_number").val(res.data.mobile_number);
				$("#email_address").val(res.data.email_address);
				$("#city").val(res.data.city);
				$("#state").val(res.data.state);
				$("#outlet_name").val(res.data.outlet_name);
				// $('#DialogBasic').modal('show');
				// $("#alert_error").text("Success");
				// $("#alert_error_msg").text(res.message);
			} else {
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(res.message);
			}
		},
		error: function (xhr, status, error) {
			$('#loader').hide();
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text(error);
		}
	});

} else if (PAGE == "MY_COMMISSION") {
	$('#loader').show();
	$.ajax({
		url: BASE_URL + 'my-commission',
		type: 'POST',
		contentType: 'application/json',
		data: JSON.stringify({
			login_key: localStorage.getItem("login_key"),
			user_id: localStorage.getItem("id")
		}),
		success: function (res) {
			$('#loader').hide();
			//$('#viewPlanDataTabs').empty();
			//$('#viewPlanData').empty();
			if (res.type == 'success') {
				html = '';
				html2 = '';
				html3 = '';
				html4 = '';
				$.each(res.data, function (j, v) {

					var cl = j.replace(/[^A-Z]+/g, "");
					html = '<div class="accordion-item"><h2 class="accordion-header" id="heading' + cl + '">' +
						'<button class="accordion-button collapsed" style="text-transform: uppercase;" type="button" data-bs-toggle="collapse" data-bs-target="#collapse' + cl + '" aria-expanded="true" aria-controls="collapse' + cl + '">' +
						j
					'</button></h2>';
					html2 = '<div id="collapse' + cl + '" class="accordion-collapse collapse" aria-labelledby="heading' + cl + '" data-bs-parent="#accordionExample">' +
						'<div class="accordion-body"><ul class="listview image-listview" id="list_' + cl + '"></ul></div></div></div>';
					$('#accordionExample').append(html);
					$('#accordionExample').append(html2);
					$.each(res.data[j], function (i, item) {
						$.each(res.data[j][0], function (i, item) {
							role_id = localStorage.getItem("role_id")
							if (role_id == 4) {
								amount_type = item.md_amount_type;
								amount_value = item.md_amount_value
							} else if (role_id == 5) {
								amount_type = item.dt_amount_type;
								amount_value = item.dt_amount_value
							} else {
								amount_type = item.rt_amount_type;
								amount_value = item.rt_amount_value
							}
							// console.log(i);
							// console.log(item);
							html3 = '<li><a href="#" class="item">' +
								'<img src="' + ADMIN_URL + 'provider_logo/' + item.p_logo + '" alt="provider_logo" class="image">' +
								'<div class="in"><div>' +
								'<header>' + item.p_name + '</header>' +
								'<footer>' + amount_type + '</footer></div>' +
								'<span class="badge badge-info">' + amount_value + '</span>' +
								"</div></a></li>"
							$('#list_' + cl).append(html3);
						});
					});
					//$('#accordionExample').append(html2);
				});
				//$('#rechargeInput').hide();
				//$('#accordionExample').show();
			} else {
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(res.message);
			}
		},
		error: function (xhr, status, error) {
			$('#loader').hide();
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text(error);
		}
	});
} else if (PAGE == "CHANGE_PASSWORD") {
	$('#loader').hide();
	$("#btn_submit").click(function () {
		current_password = $('#old_password').val();
		new_password = $('#new_password').val();
		confirm_password = $('#confirm_password').val();
		if (current_password == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter old password");
		} else if (new_password == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter new password");
		} else if (confirm_password == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter confirm password");
		} else if (new_password != confirm_password) {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("new password & confirm password do not match.");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'change-password',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					current_password,
					new_password,
					confirm_password,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#old_password').val('');
						$('#new_password').val('');
						$('#confirm_password').val('');
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						setTimeout(function () {
							location.reload();
						}, 2000);
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	});
} else if (PAGE == "CHANGE_PIN") {

	$('#loader').hide();
	function generatePin(id) {
		$('#loader').show();
		$.ajax({
			url: BASE_URL + 'generate-pin',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id")
			}),
			success: function (res) {
				$('#loader').hide();
				if (res.type == 'success') {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Success");
					$("#alert_error_msg").text(res.message);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
	$("#btn_submit").click(function () {
		current_pin = $('#old_pin').val();
		new_pin = $('#new_pin').val();
		confirm_pin = $('#confirm_pin').val();
		if (current_pin == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter old pin");
		} else if (new_pin == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter new pin");
		} else if (confirm_pin == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter confirm pin");
		} else if (new_pin != confirm_pin) {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("new pin & confirm pin do not match.");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'change-pin',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					current_pin,
					new_pin,
					confirm_pin,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						// $('#old_pin').val('');
						// $('#new_pin').val('');
						// $('#confirm_pin').val('');
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						setTimeout(function () {
							location.reload();
						}, 2000);
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	});
} else if (PAGE == "ADD_USER") {
	$('#loader').hide();
	$("#btn_submit").click(function () {
		first_name = $('#first_name').val();
		middle_name = $('#middle_name').val();
		last_name = $('#last_name').val();
		mobile_number = $('#mobile_number').val();
		email_address = $('#email_address').val();
		state = $('#state').val();
		city = $('#city').val();
		outlet_name = $('#outlet_name').val();
		if(first_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter first name");
		}else if (middle_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter middle name");
		} else if (last_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter last name");
		} else if (mobile_number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter mobile number");
		} else if (email_address == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter email address");
		} else if (state == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter state");
		} else if (city == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter city");
		} else if (outlet_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter outlet name");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'add-user',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					outlet_name,
					first_name,
					middle_name,
					last_name,
					mobile_number,
					email_address,
					city,
					state,
					date_of_birth: 0,
					gender: "Male",
					flat_door_no: 0,
					road_street: 0,
					area_locality: 0,
					district: 0,
					bank_account_number: "1234567890",
					branch_name: 0,
					ifsc_code: 0,
					bank_account_type: "Savings",
					status: 1,
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	});
} else if (PAGE == "USER_LIST") {

	function checkUsers() {
		let mobile_number = $('#user_mob_no').val();
		if(mobile_number == ""){
			fetchAllData();
		}
		if (mobile_number.length == 3) {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'search-user-list-name',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					mobile_number
				}),
				success: function (res) {
					$('#loader').hide();
						html = '';
						if (res.users.length) {

							$.each(res.users, function (i, item) {
								if (item.status == 1) {
									s_bg = "success";
									u_status = "Active";
								} else {
									s_bg = "danger";
									u_status = "Deactive";
								}
	
								html += '<div id="' + i + '" class="round_div mt-1">' +
									'<div class="row text-center p-2">' +
									'<div class="col-4">' +
									'<a style="font-size: 18px;font-weight: 500;color: green;">'+ item.mobile_number + '</a>' +
									'</div>' +
									'<div class="col-4">' +
									'<span class="badge badge-' + s_bg + '">' + u_status + '</span>' +
									'</div>' +
									'<div class="col-4">' +
									'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.wallet_balance + '</a>' +
									'</div>' +
									'</div>' +
									'<div class="row pt-1" style="padding-left: 16px !important;">' +
									'<div class="col-12">' +
									'<a style="font-weight: bold;">Outlet Name : </a><a >' + item.outlet_name + '</a>' +
									'</div>' +
									'<div class="col-12" style="padding-top: 1px;">' +
									'<a style="font-weight: bold;">Name : </a><a >' + item.first_name + ' ' + item.middle_name + ' ' + item.last_name + '</a>' +
									'</div>' +
									
									'<div class="col-12">' +
									'<a style="font-weight: bold;">Email Address : </a><a >' + item.email_address + '</a>' +
									'</div>' +
									'<div class="col-12">' +
									'<a style="font-weight: bold;">City : </a><a >' + item.city + '</a>' +
									'</div>' +
									'<div class="row text-center p-1">' +
									'<div class="col-2">' +
									'</div>' +
									'<div class="col-6">' +
									'<a href="fund-transfer.html?id=' + item.id + '&mob=' + item.mobile_number + '" class="btn btn-primary">Fund Transfer</a>' +
									'</div>' +
									'</div>' +
									'</div>' +
									'</div>';
							})
						} else {
							html = ' <center><h3 class="mt-2">Record not found</h3></center>';
						}
						$('#results2').html(html);
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}


	fetchAllData();
	function fetchAllData() {
		let user_id = $("#user_id").val();
		$("#loader").show();
		$("#searchBtn").text("WAIT...");
		$("#searchBtn").attr("disabled", true);
		$.ajax({
			url: BASE_URL + 'user-list',
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				login_key: localStorage.getItem("login_key"),
				user_id: localStorage.getItem("id"),
				page: 1,
				limit: 50,
				status: "All",
				kyc_status: "All",
				s_user_id : user_id,
				role_id : 0,
				s_user_id : 0,
				parent_id: 0,
			}),
			success: function (res) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				if (res.type == 'success') {
					html = ''
					if (res.data.length) {

						$.each(res.data, function (i, item) {
							if (item.status == 1) {
								s_bg = "success";
								u_status = "Active";
							} else {
								s_bg = "danger";
								u_status = "Deactive";
							}

							html += '<div id="' + i + '" class="round_div mt-1">' +
								'<div class="row text-center p-2">' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">'+ item.mobile_number + '</a>' +
								'</div>' +
								'<div class="col-4">' +
								'<span class="badge badge-' + s_bg + '">' + u_status + '</span>' +
								'</div>' +
								'<div class="col-4">' +
								'<a style="font-size: 18px;font-weight: 500;color: green;">₹ ' + item.wallet_balance + '</a>' +
								'</div>' +
								'</div>' +
								'<div class="row pt-1" style="padding-left: 16px !important;">' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Outlet Name : </a><a >' + item.outlet_name + '</a>' +
								'</div>' +
								'<div class="col-12" style="padding-top: 1px;">' +
								'<a style="font-weight: bold;">Name : </a><a >' + item.first_name + ' ' + item.middle_name + ' ' + item.last_name + '</a>' +
								'</div>' +
								
								'<div class="col-12">' +
								'<a style="font-weight: bold;">Email Address : </a><a >' + item.email_address + '</a>' +
								'</div>' +
								'<div class="col-12">' +
								'<a style="font-weight: bold;">City : </a><a >' + item.city + '</a>' +
								'</div>' +
								'<div class="row text-center p-1">' +
								'<div class="col-2">' +
								'</div>' +
								'<div class="col-6">' +
								'<a href="fund-transfer.html?id=' + item.id + '&mob=' + item.mobile_number + '" class="btn btn-primary">Fund Transfer</a>' +
								'</div>' +
								'</div>' +
								'</div>' +
								'</div>';
						})
					} else {
						html = ' <center><h3 class="mt-2">Record not found</h3></center>';
					}
					$('#results2').html(html);
				} else {
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(res.message);
				}
			},
			error: function (xhr, status, error) {
				$("#searchBtn").text("SEARCH");
				$("#searchBtn").attr("disabled", false);
				$('#loader').hide();
				$('#DialogBasic').modal('show');
				$("#alert_error").text("Error");
				$("#alert_error_msg").text(error);
			}
		});
	}
} else if (PAGE == "FUND_TRANSFER") {
	var getUrlParameter = function getUrlParameter(sParam) {
		var sPageURL = window.location.search.substring(1),
			sURLVariables = sPageURL.split('&'),
			sParameterName,
			i;
	
		for (i = 0; i < sURLVariables.length; i++) {
			sParameterName = sURLVariables[i].split('=');
	
			if (sParameterName[0] === sParam) {
				return sParameterName[1] === undefined ? true : decodeURIComponent(sParameterName[1]);
			}
		}
		return false;
	};
	var id = getUrlParameter('id');
	var mob = getUrlParameter('mob');
	if(mob){
		$('#t_id').val(id);
		$('#user_mob_no').val(mob);
	}
	$('#loader').hide();
	function checkUsers() {
		let mobile_number = $('#user_mob_no').val();
		if (mobile_number.length === 10) {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'search-user-list',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					mobile_number
				}),
				success: function (res) {
					$('#loader').hide();
						html = '';

							if (res.users.length) {

								$.each(res.users, function (i, item) {

									if (item.status == 1) {
										s_bg = "green";
									} else {
										s_bg = "red";
									}
									html = ' <a class="mt-1" style="font-size: 12px;color: ' + s_bg + ';text-transform: uppercase;">' + item.first_name + ' ' + item.middle_name + ' ' + item.last_name + '  : ₹ ' + item.wallet_balance + '</a>';
									$('#t_id').val(item.id);
								})
							} else {
								html = ' <a class="mt-2" style="font-size: 12px;color: red;text-transform: uppercase;">Record not found</a>';
							}
							$('#name').html(html);
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}


	$("#btn_submit").click(function () {
		id = $('#t_id').val();
		amount = $('#f_amount').val();
		remark = $('#f_remark').val();
		if(id == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter mobile number");
		}else if (amount == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter amount");
		} else if (remark == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter remark");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'fund-transfer',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					id,
					amount,
					type: "Transfer",
					remark
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						$('#t_id').val("");
						$('#f_amount').val("");
						$('#f_remark').val("");
						$('#name').html("");
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	});
} else if (PAGE == "CREATE_NEW_ACCOUNT_PAGE") {
	$('#loader').hide();
	$("#cna_btn").click(function () {
		first_name = $('#first_name').val();
		last_name = $('#last_name').val();
		mobile_number = $('#mobile_number').val();
		email_address = $('#email_address').val();
		city = $('#city').val();
		if(first_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter first name");
		} else if (last_name == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter last name");
		} else if (mobile_number == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter mobile number");
		} else if (email_address == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter email address");
		} else if (city == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error_msg").text("enter city");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'create-account',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					login_key: localStorage.getItem("login_key"),
					user_id: localStorage.getItem("id"),
					first_name,
					last_name,
					mobile_number,
					email_address,
					city_name:city
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'otp_verify') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);

						$("#token_otp").val(res.token);
						$("#create_from").hide();
						$("#otp_verify").show();
						///$("#login_otp_btn").show();
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	});


	function createVerifyOtp() {
		//e.preventDefault();
		var mobile = $("#mobile_number").val();
		var otp = $("#input_otp").val();
		var token = $("#token_otp").val();
		if (mobile == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter mobile number");
		} else if (otp == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter otp");
		} else if (token == "") {
			$('#DialogBasic').modal('show');
			$("#alert_error").text("Error");
			$("#alert_error_msg").text("enter token");
		} else {
			$('#loader').show();
			$.ajax({
				url: BASE_URL + 'create-account-otp',
				type: 'POST',
				contentType: 'application/json',
				data: JSON.stringify({
					mobile_number: mobile,
					token: token,
					otp: otp
				}),
				success: function (res) {
					$('#loader').hide();
					if (res.type == 'success') {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Success");
						$("#alert_error_msg").text(res.message);
						localStorage.setItem("islogin", 1);
						localStorage.setItem("id", res.data.user_id);
						localStorage.setItem("role_id", res.data.role_id);
						localStorage.setItem("parent_id", res.data.parent_id);
						localStorage.setItem("login_key", res.data.login_key);
						localStorage.setItem("states", JSON.stringify(res.data.states));
						localStorage.setItem("mobile_provider", JSON.stringify(res.data.mobile_provider));
						localStorage.setItem("postpaid_provider", JSON.stringify(res.data.postpaid_provider));
						localStorage.setItem("dth_provider", JSON.stringify(res.data.dth_provider));
						window.location.replace('home.html');
					} else {
						$('#DialogBasic').modal('show');
						$("#alert_error").text("Error");
						$("#alert_error_msg").text(res.message);
					}
				},
				error: function (xhr, status, error) {
					$('#loader').hide();
					$('#DialogBasic').modal('show');
					$("#alert_error").text("Error");
					$("#alert_error_msg").text(error);
				}
			});
		}
	}

}



