<?php

namespace App\Http\Controllers\Users;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Redirect;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
class CallBackController extends Controller
{
    public function rechargeCallback(Request $post,$api_id){
        if(!$_REQUEST){
            return response()->json(array(
                'type' => 'error',  
                'message' => "param not found "
            ));
        }
        $api = DB::table('apis')->where('id',$api_id)->first();
        if($api){
            $status = $api->callback_status_value;
            $success = $api->callback_success_value;
            $failed = $api->callback_failed_value;
            $refund = $api->callback_refund_value;
            $operator_id = $api->callback_operator_id_value;
            $order_id = $api->callback_order_id_value;
            $data = json_encode($_REQUEST);
            $data= json_decode($data,true);
            if($data[$status] == $success){
                $update['status'] = "Success";
                $update['operator_id'] = $data[$operator_id];
                $update['callback_response'] = $_SERVER['REQUEST_URI'];
            }else if($data[$status] == $failed) {
                $update['status'] = "Failed";
                $update['operator_id'] = $data[$operator_id];
                $update['callback_response'] = $_SERVER['REQUEST_URI'];
            }else if($data[$status] == $refund) {
                $update['status'] = "Refunded";
                $update['operator_id'] = $data[$operator_id];
                $update['callback_response'] = $_SERVER['REQUEST_URI']; 
            }else{
                $update['status'] = "Pending";
            }

            if($update['status'] == "Refunded"){
                $report = DB::table('reports')->where('order_id', $data[$order_id])->where('status', 'Success')->where('parent__id', 0)->first();
                if($report){
                    DB::table('reports')->where('id', $report->id)->update($update);
                    \helpers::refund_row($report->id);
                    $r_com = \helpers::ReverseCommission($report->id);
                    $c_report = DB::table('complaints')->where('order_id', $data[$order_id])->where('status', 'Open')->first();
                    if($c_report){
                        $complaint_u = DB::table('complaints')->where('id', $c_report->id)->update([
                            'decision_by' => 1,
                            'decision_remark' => "Recharge Refunded",
                            'status' => "Sloved",
                            'decision_date' => Carbon::now(),
                            'updated_at' => Carbon::now()
                        ]);
                        DB::table('reports')->where('id', $complaint_u->report_id)->update([
                            'complaint_id' => 0
                        ]);
                        return response()->json(array(
                            'type' => 'success',  
                            'message' => "recharge refunded success.complaints"
                        ));
                    }else{
                        return response()->json(array(
                            'type' => 'success',  
                            'message' => "recharge refunded success.normal"
                        ));
                    }
                }else{
                    return response()->json(array(
                        'type' => 'error',  
                        'message' => "record not found.Refunded"
                    ));
                }
                
            }

            $report = DB::table('reports')->where('order_id', $data[$order_id])->where('api_id', $api_id)->where('status', 'Pending')->first();
            if($report){
                if($update['status'] == "Success"){
                    DB::table('reports')->where('id', $report->id)->update($update);
                    $set_com = \helpers::SetCommission($report->id);
                    return response()->json($update);
                }else if($update['status'] == "Failed"){
                    DB::table('reports')->where('id', $report->id)->update($update);
                    \helpers::refund_row($report->id);
                    return response()->json($update);
                // }else if($update['status'] == "Refunded"){
                //     DB::table('reports')->where('id', $report->id)->update($update);
                //     \helpers::refund_row($report->id);
                //     return response()->json($update);
                }else{
                    return response()->json(array(
                        'type' => 'error',  
                        'message' => "status is pending."
                    ));
                }
                
            }else{
                return response()->json(array(
                    'type' => 'error',  
                    'message' => "record not found."
                ));
            }
            //return $report;
        }else{
            return response()->json(array(
                'type' => 'error',  
                'message' => "not found api."
            ));
        }
        
    }
   
}
