@extends('layouts.master')

@section('title') Api Documents @endsection

@section('css')

<!--datatable css-->

<link href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />

<!--datatable responsive css-->

<link href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css" rel="stylesheet"
    type="text/css" />

<link href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css" rel="stylesheet" type="text/css" />

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

@endsection

@section('content')

@component('components.breadcrumb')

@slot('li_1') Profile @endslot

@slot('title') Api Documents @endslot

@endcomponent

@php

@endphp


<div class="row">

    <div class="col-lg-12">

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Recharge & Bill Payments Request
                    Request - (GET, POST)</h4>

            </div>

            <div class="card-body">
                <h6>
                    Request URL :
                </h6>
                <p>
                    {{($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http"}}://{{$_SERVER['SERVER_NAME']}}/api/ApiPartner/V1/Recharge?api_key={API_KEY}&provider_id={PROVIDER_CODE}&service_id={SERVICE_ID}&number={NUMBER}&amount={AMOUNT}&pin={PIN}&request_order_id={ORDER_ID}&
                    optional_1={OPTIONAL1}&
                    optional_2={OPTIONAL2}&
                    optional_3={OPTIONAL3}&
                    optional_4={OPTIONAL4}&
                    optional_5={OPTIONAL5}
                </p>
                <h6>
                    Request Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered ">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>
                                <th scope="col">Required</th>
                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>api_key</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>
                            </tr>

                            <tr data-item-id="">
                                <td>pin</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>

                            </tr>
                            <tr data-item-id="">
                                <td>number</td>
                                <td>MANDATORY</td>
                                <td>User Account or Mobile No</td>


                            </tr>
                            <tr data-item-id="">
                                <td>amount</td>
                                <td>MANDATORY</td>
                                <td>Amount To be Recharge</td>
                            </tr>
                            <tr data-item-id="">
                                <td>provider_id</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile-my-commission" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>
                            </tr>
                            <tr data-item-id="">
                                <td>service_id</td>
                                <td>MANDATORY</td>
                                <td>pass 1</td>
                            </tr>
                            <tr data-item-id="">
                                <td>request_order_id</td>
                                <td>MANDATORY</td>
                                <td>Unique Reference ID Provided By Your Self</td>
                            </tr>
                            <tr data-item-id="">
                                <td>optional_1</td>
                                <td>OPTIONAL</td>
                                <td>Extra Parameters</td>
                            </tr>
                            <tr data-item-id="">
                                <td>optional_2</td>
                                <td>OPTIONAL</td>
                                <td>Extra Parameters</td>
                            </tr>
                            <tr data-item-id="">
                                <td>optional_3</td>
                                <td>OPTIONAL</td>
                                <td>Extra Parameters</td>
                            </tr>
                            <tr data-item-id="">
                                <td>optional_4</td>
                                <td>OPTIONAL</td>
                                <td>Extra Parameters</td>
                            </tr>
                            <tr data-item-id="">
                                <td>optional_5</td>
                                <td>OPTIONAL</td>
                                <td>Extra Parameters</td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <h6>
                    Response Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered" id="tblDR">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>

                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>status</td>
                                <td>Success/ Failed/ Pending</td>

                            </tr>
                            <tr data-item-id="">
                                <td>message</td>
                                <td>Error Description</td>
                            </tr>
                            <tr data-item-id="">
                                <td>remark</td>
                                <td>Remark Description</td>
                            </tr>
                            <tr data-item-id="">
                                <td>commission</td>
                                <td>YOUR COMMISSION</td>

                            </tr>
                            <tr data-item-id="">
                                <td>type</td>
                                <td>success/ error</td>

                            </tr>
                            <tr data-item-id="">
                                <td>number</td>
                                <td>User Account or Mobile No</td>

                            </tr>
                            <tr data-item-id="">
                                <td>amount</td>
                                <td>REQUESTED AMOUNT</td>

                            </tr>
                            <tr data-item-id="">
                                <td>request_order_id</td>
                                <td>YOUR UNIQUE REQUEST ORDER ID</td>

                            </tr>
                            <tr data-item-id="">
                                <td>order_id</td>
                                <td>COMAPNY UNIQUE REQUEST ORDER ID</td>

                            </tr>
                            <tr data-item-id="">
                                <td>operator_id</td>
                                <td>LIVE ID</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>


        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Transaction Status Check - (GET, POST)</h4>

            </div>

            <div class="card-body">
                <h6>
                    Request URL :
                </h6>
                <p>
                    {{($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http"}}://{{$_SERVER['SERVER_NAME']}}/api/ApiPartner/V1/RechargeStatus?api_key={API_KEY}&request_order_id={YOUR_ORDER_ID}
                </p>
                <h6>
                    Request Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered ">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>
                                <th scope="col">Required</th>
                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>api_key</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>
                            </tr>

                                <tr data-item-id="">
                                <td>request_order_id</td>
                                <td>MANDATORY</td>
                                <td>YOUR UNIQUE REQUEST ORDER ID</td>

                            </tr>

                        </tbody>
                    </table>
                </div>
                <h6>
                    Response Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered" id="tblDR">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>

                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>status</td>
                                <td>Success/ Failed/ Pending</td>

                            </tr>
                            <tr data-item-id="">
                                <td>message</td>
                                <td>Error Description</td>
                            </tr>
                            <tr data-item-id="">
                                <td>remark</td>
                                <td>Remark Description</td>
                            </tr>
                            <tr data-item-id="">
                                <td>commission</td>
                                <td>YOUR COMMISSION</td>

                            </tr>
                            <tr data-item-id="">
                                <td>type</td>
                                <td>success/ error</td>

                            </tr>
                            <tr data-item-id="">
                                <td>number</td>
                                <td>User Account or Mobile No</td>

                            </tr>
                            <tr data-item-id="">
                                <td>amount</td>
                                <td>REQUESTED AMOUNT</td>

                            </tr>
                            <tr data-item-id="">
                                <td>request_order_id</td>
                                <td>YOUR UNIQUE REQUEST ORDER ID</td>

                            </tr>
                            <tr data-item-id="">
                                <td>order_id</td>
                                <td>COMAPNY UNIQUE REQUEST ORDER ID</td>

                            </tr>
                            <tr data-item-id="">
                                <td>operator_id</td>
                                <td>LIVE ID</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Balance Check - (GET, POST)</h4>

            </div>

            <div class="card-body">
                <h6>
                    Request URL :
                </h6>
                <p>
                    {{($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http"}}://{{$_SERVER['SERVER_NAME']}}/api/ApiPartner/V1/Balance?api_key={API_KEY}
                </p>
                <h6>
                    Request Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered ">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>
                                <th scope="col">Required</th>
                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>api_key</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <h6>
                    Response Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered" id="tblDR">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>

                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>type</td>
                                <td>success/ error</td>

                            </tr>
                            <tr data-item-id="">
                                <td>balance</td>
                                <td>Wallet Balance</td>
                            </tr>
                            <tr data-item-id="">
                                <td>message</td>
                                <td>Message Description</td>
                            </tr>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Complaint - (GET, POST)</h4>

            </div>

            <div class="card-body">
                <h6>
                    Request URL :
                </h6>
                <p>
                    {{($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http"}}://{{$_SERVER['SERVER_NAME']}}/api/ApiPartner/V1/RechargeComplaint?api_key={API_KEY}&order_id={COMAPNY_ORDER_ID}&subject={SUBJECT}
                </p>
                <h6>
                    Request Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered ">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>
                                <th scope="col">Required</th>
                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>api_key</td>
                                <td>MANDATORY</td>
                                <td><a href="/users/profile/my-profile" target="_blank"
                                        class="btn btn-primary"> Click to View</a>
                                </td>
                            </tr>
                                <tr data-item-id="">
                                <td>order_id</td>
                                <td>MANDATORY</td>
                                <td>COMPANY UNIQUE REQUEST ORDER ID</td>
                            </tr>
                            </tr>
                                <tr data-item-id="">
                                <td>subject</td>
                                <td>MANDATORY</td>
                                <td>Compalint Subject</td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <h6>
                    Response Parameter :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered" id="tblDR">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>

                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>type</td>
                                <td>success/ error</td>

                            </tr>
                            <tr data-item-id="">
                                <td>message</td>
                                <td>Message Description</td>
                            </tr>
                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card">

            <div class="card-header align-items-center d-flex">

                <h4 class="card-title mb-0 flex-grow-1">Webhook Response - (GET)</h4>

            </div>

            <div class="card-body">
                <h6>
                    Request URL :
                </h6>
                <p>
                https://callbackurl.com?request_order_id=&status=Success&amount=10&order_id=RC20240603125357956120259&operator_id=88178
                </p>
                
                <h6>
                    Response Tags :
                </h6>
                <div class="table-responsive">
                    <table class="table table-bordered" id="tblDR">
                        <thead class="bg-tableth">
                            <tr>
                                <th scope="col">Parameter </th>

                                <th scope="col">Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr data-item-id="">
                                <td>status</td>
                                <td>Success/ Failed/ Refunded</td>

                            </tr>
                            <tr data-item-id="">
                                <td>request_order_id</td>
                                <td>Your Request Order Id</td>
                            </tr>
                            <tr data-item-id="">
                                <td>order_id</td>
                                <td>Comapany Unique Order Id</td>
                            </tr>
                            <tr data-item-id="">
                                <td>amount</td>
                                <td>Trasaction Amount</td>
                            </tr>
                            <tr data-item-id="">
                                <td>operator_id</td>
                                <td>Operator Id Means Provide Operator End</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

</div>



@endsection

@section('script')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"
    integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script src="{{ URL::asset('/assets/js/app.min.js') }}"></script>
@endsection